// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * User identity details.
 */
@Fluent
public final class UserIdentityContractInner implements JsonSerializable<UserIdentityContractInner> {
    /*
     * Identity provider name.
     */
    private String provider;

    /*
     * Identifier value within provider.
     */
    private String id;

    /**
     * Creates an instance of UserIdentityContractInner class.
     */
    public UserIdentityContractInner() {
    }

    /**
     * Get the provider property: Identity provider name.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.provider;
    }

    /**
     * Set the provider property: Identity provider name.
     * 
     * @param provider the provider value to set.
     * @return the UserIdentityContractInner object itself.
     */
    public UserIdentityContractInner withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    /**
     * Get the id property: Identifier value within provider.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Identifier value within provider.
     * 
     * @param id the id value to set.
     * @return the UserIdentityContractInner object itself.
     */
    public UserIdentityContractInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserIdentityContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserIdentityContractInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserIdentityContractInner.
     */
    public static UserIdentityContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserIdentityContractInner deserializedUserIdentityContractInner = new UserIdentityContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provider".equals(fieldName)) {
                    deserializedUserIdentityContractInner.provider = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedUserIdentityContractInner.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserIdentityContractInner;
        });
    }
}
