// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.KeyType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Parameters supplied to the Get User Token operation.
 */
@Fluent
public final class UserTokenParameterProperties implements JsonSerializable<UserTokenParameterProperties> {
    /*
     * The Key to be used to generate token for user.
     */
    private KeyType keyType;

    /*
     * The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date conforms to the following
     * format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     */
    private OffsetDateTime expiry;

    /**
     * Creates an instance of UserTokenParameterProperties class.
     */
    public UserTokenParameterProperties() {
    }

    /**
     * Get the keyType property: The Key to be used to generate token for user.
     * 
     * @return the keyType value.
     */
    public KeyType keyType() {
        return this.keyType;
    }

    /**
     * Set the keyType property: The Key to be used to generate token for user.
     * 
     * @param keyType the keyType value to set.
     * @return the UserTokenParameterProperties object itself.
     */
    public UserTokenParameterProperties withKeyType(KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    /**
     * Get the expiry property: The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date
     * conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the expiry value.
     */
    public OffsetDateTime expiry() {
        return this.expiry;
    }

    /**
     * Set the expiry property: The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date
     * conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param expiry the expiry value to set.
     * @return the UserTokenParameterProperties object itself.
     */
    public UserTokenParameterProperties withExpiry(OffsetDateTime expiry) {
        this.expiry = expiry;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property keyType in model UserTokenParameterProperties"));
        }
        if (expiry() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property expiry in model UserTokenParameterProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UserTokenParameterProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyType", this.keyType == null ? null : this.keyType.toString());
        jsonWriter.writeStringField("expiry",
            this.expiry == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiry));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserTokenParameterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserTokenParameterProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UserTokenParameterProperties.
     */
    public static UserTokenParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserTokenParameterProperties deserializedUserTokenParameterProperties = new UserTokenParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyType".equals(fieldName)) {
                    deserializedUserTokenParameterProperties.keyType = KeyType.fromString(reader.getString());
                } else if ("expiry".equals(fieldName)) {
                    deserializedUserTokenParameterProperties.expiry = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserTokenParameterProperties;
        });
    }
}
