// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Get User Token response details.
 */
@Fluent
public final class UserTokenResultInner implements JsonSerializable<UserTokenResultInner> {
    /*
     * Shared Access Authorization token for the User.
     */
    private String value;

    /**
     * Creates an instance of UserTokenResultInner class.
     */
    public UserTokenResultInner() {
    }

    /**
     * Get the value property: Shared Access Authorization token for the User.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Shared Access Authorization token for the User.
     * 
     * @param value the value value to set.
     * @return the UserTokenResultInner object itself.
     */
    public UserTokenResultInner withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserTokenResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserTokenResultInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserTokenResultInner.
     */
    public static UserTokenResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserTokenResultInner deserializedUserTokenResultInner = new UserTokenResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedUserTokenResultInner.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserTokenResultInner;
        });
    }
}
