// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.WikiDocumentationContract;
import java.io.IOException;
import java.util.List;

/**
 * Wiki properties.
 */
@Fluent
public final class WikiContractInner extends ProxyResource {
    /*
     * Wiki details.
     */
    private WikiContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of WikiContractInner class.
     */
    public WikiContractInner() {
    }

    /**
     * Get the innerProperties property: Wiki details.
     * 
     * @return the innerProperties value.
     */
    private WikiContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the documents property: Collection wiki documents included into this wiki.
     * 
     * @return the documents value.
     */
    public List<WikiDocumentationContract> documents() {
        return this.innerProperties() == null ? null : this.innerProperties().documents();
    }

    /**
     * Set the documents property: Collection wiki documents included into this wiki.
     * 
     * @param documents the documents value to set.
     * @return the WikiContractInner object itself.
     */
    public WikiContractInner withDocuments(List<WikiDocumentationContract> documents) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WikiContractProperties();
        }
        this.innerProperties().withDocuments(documents);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WikiContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WikiContractInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WikiContractInner.
     */
    public static WikiContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WikiContractInner deserializedWikiContractInner = new WikiContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedWikiContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedWikiContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedWikiContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedWikiContractInner.innerProperties = WikiContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWikiContractInner;
        });
    }
}
