// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.models.WikiDocumentationContract;
import java.io.IOException;
import java.util.List;

/**
 * Wiki contract details.
 */
@Fluent
public final class WikiContractProperties implements JsonSerializable<WikiContractProperties> {
    /*
     * Collection wiki documents included into this wiki.
     */
    private List<WikiDocumentationContract> documents;

    /**
     * Creates an instance of WikiContractProperties class.
     */
    public WikiContractProperties() {
    }

    /**
     * Get the documents property: Collection wiki documents included into this wiki.
     * 
     * @return the documents value.
     */
    public List<WikiDocumentationContract> documents() {
        return this.documents;
    }

    /**
     * Set the documents property: Collection wiki documents included into this wiki.
     * 
     * @param documents the documents value to set.
     * @return the WikiContractProperties object itself.
     */
    public WikiContractProperties withDocuments(List<WikiDocumentationContract> documents) {
        this.documents = documents;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (documents() != null) {
            documents().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WikiContractProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WikiContractProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WikiContractProperties.
     */
    public static WikiContractProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WikiContractProperties deserializedWikiContractProperties = new WikiContractProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("documents".equals(fieldName)) {
                    List<WikiDocumentationContract> documents
                        = reader.readArray(reader1 -> WikiDocumentationContract.fromJson(reader1));
                    deserializedWikiContractProperties.documents = documents;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWikiContractProperties;
        });
    }
}
