// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Workspace details.
 */
@Fluent
public final class WorkspaceContractInner extends ProxyResource {
    /*
     * Workspace entity contract properties.
     */
    private WorkspaceContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of WorkspaceContractInner class.
     */
    public WorkspaceContractInner() {
    }

    /**
     * Get the innerProperties property: Workspace entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private WorkspaceContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the displayName property: Name of the workspace.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Name of the workspace.
     * 
     * @param displayName the displayName value to set.
     * @return the WorkspaceContractInner object itself.
     */
    public WorkspaceContractInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceContractProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the description property: Description of the workspace.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description of the workspace.
     * 
     * @param description the description value to set.
     * @return the WorkspaceContractInner object itself.
     */
    public WorkspaceContractInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkspaceContractInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkspaceContractInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WorkspaceContractInner.
     */
    public static WorkspaceContractInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkspaceContractInner deserializedWorkspaceContractInner = new WorkspaceContractInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedWorkspaceContractInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedWorkspaceContractInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedWorkspaceContractInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedWorkspaceContractInner.innerProperties = WorkspaceContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkspaceContractInner;
        });
    }
}
