// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.AccessInformationContractInner;
import com.azure.resourcemanager.apimanagement.models.AccessIdName;
import com.azure.resourcemanager.apimanagement.models.AccessInformationContract;
import com.azure.resourcemanager.apimanagement.models.AccessInformationCreateParameters;
import com.azure.resourcemanager.apimanagement.models.AccessInformationSecretsContract;
import com.azure.resourcemanager.apimanagement.models.AccessInformationUpdateParameters;

public final class AccessInformationContractImpl
    implements AccessInformationContract, AccessInformationContract.Definition, AccessInformationContract.Update {
    private AccessInformationContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String idPropertiesId() {
        return this.innerModel().idPropertiesId();
    }

    public String principalId() {
        return this.innerModel().principalId();
    }

    public Boolean enabled() {
        return this.innerModel().enabled();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public AccessInformationContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private AccessIdName accessName;

    private String createIfMatch;

    private AccessInformationCreateParameters createParameters;

    private String updateIfMatch;

    private AccessInformationUpdateParameters updateParameters;

    public AccessInformationContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public AccessInformationContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getTenantAccess()
            .createWithResponse(resourceGroupName, serviceName, accessName, createIfMatch, createParameters,
                Context.NONE)
            .getValue();
        return this;
    }

    public AccessInformationContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getTenantAccess()
            .createWithResponse(resourceGroupName, serviceName, accessName, createIfMatch, createParameters, context)
            .getValue();
        return this;
    }

    AccessInformationContractImpl(AccessIdName name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new AccessInformationContractInner();
        this.serviceManager = serviceManager;
        this.accessName = name;
        this.createIfMatch = null;
        this.createParameters = new AccessInformationCreateParameters();
    }

    public AccessInformationContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new AccessInformationUpdateParameters();
        return this;
    }

    public AccessInformationContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getTenantAccess()
            .updateWithResponse(resourceGroupName, serviceName, accessName, updateIfMatch, updateParameters,
                Context.NONE)
            .getValue();
        return this;
    }

    public AccessInformationContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getTenantAccess()
            .updateWithResponse(resourceGroupName, serviceName, accessName, updateIfMatch, updateParameters, context)
            .getValue();
        return this;
    }

    AccessInformationContractImpl(AccessInformationContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.accessName
            = AccessIdName.fromString(ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "tenant"));
    }

    public AccessInformationContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getTenantAccess()
            .getWithResponse(resourceGroupName, serviceName, accessName, Context.NONE)
            .getValue();
        return this;
    }

    public AccessInformationContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getTenantAccess()
            .getWithResponse(resourceGroupName, serviceName, accessName, context)
            .getValue();
        return this;
    }

    public Response<Void> regeneratePrimaryKeyWithResponse(Context context) {
        return serviceManager.tenantAccess()
            .regeneratePrimaryKeyWithResponse(resourceGroupName, serviceName, accessName, context);
    }

    public void regeneratePrimaryKey() {
        serviceManager.tenantAccess().regeneratePrimaryKey(resourceGroupName, serviceName, accessName);
    }

    public Response<Void> regenerateSecondaryKeyWithResponse(Context context) {
        return serviceManager.tenantAccess()
            .regenerateSecondaryKeyWithResponse(resourceGroupName, serviceName, accessName, context);
    }

    public void regenerateSecondaryKey() {
        serviceManager.tenantAccess().regenerateSecondaryKey(resourceGroupName, serviceName, accessName);
    }

    public Response<AccessInformationSecretsContract> listSecretsWithResponse(Context context) {
        return serviceManager.tenantAccess()
            .listSecretsWithResponse(resourceGroupName, serviceName, accessName, context);
    }

    public AccessInformationSecretsContract listSecrets() {
        return serviceManager.tenantAccess().listSecrets(resourceGroupName, serviceName, accessName);
    }

    public AccessInformationContractImpl withPrincipalId(String principalId) {
        this.createParameters.withPrincipalId(principalId);
        return this;
    }

    public AccessInformationContractImpl withPrimaryKey(String primaryKey) {
        this.createParameters.withPrimaryKey(primaryKey);
        return this;
    }

    public AccessInformationContractImpl withSecondaryKey(String secondaryKey) {
        this.createParameters.withSecondaryKey(secondaryKey);
        return this;
    }

    public AccessInformationContractImpl withEnabled(Boolean enabled) {
        if (isInCreateMode()) {
            this.createParameters.withEnabled(enabled);
            return this;
        } else {
            this.updateParameters.withEnabled(enabled);
            return this;
        }
    }

    public AccessInformationContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
