// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.AllPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AllPoliciesContractInner;
import com.azure.resourcemanager.apimanagement.models.AllPolicies;
import com.azure.resourcemanager.apimanagement.models.AllPoliciesContract;

public final class AllPoliciesImpl implements AllPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(AllPoliciesImpl.class);

    private final AllPoliciesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public AllPoliciesImpl(AllPoliciesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<AllPoliciesContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<AllPoliciesContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AllPoliciesContractImpl(inner1, this.manager()));
    }

    public PagedIterable<AllPoliciesContract> listByService(String resourceGroupName, String serviceName,
        Context context) {
        PagedIterable<AllPoliciesContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AllPoliciesContractImpl(inner1, this.manager()));
    }

    private AllPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
