// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiContactInformation;
import com.azure.resourcemanager.apimanagement.models.ApiContract;
import com.azure.resourcemanager.apimanagement.models.ApiCreateOrUpdateParameter;
import com.azure.resourcemanager.apimanagement.models.ApiCreateOrUpdatePropertiesWsdlSelector;
import com.azure.resourcemanager.apimanagement.models.ApiLicenseInformation;
import com.azure.resourcemanager.apimanagement.models.ApiType;
import com.azure.resourcemanager.apimanagement.models.ApiUpdateContract;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetContractDetails;
import com.azure.resourcemanager.apimanagement.models.AuthenticationSettingsContract;
import com.azure.resourcemanager.apimanagement.models.ContentFormat;
import com.azure.resourcemanager.apimanagement.models.Protocol;
import com.azure.resourcemanager.apimanagement.models.SoapApiType;
import com.azure.resourcemanager.apimanagement.models.SubscriptionKeyParameterNamesContract;
import com.azure.resourcemanager.apimanagement.models.TranslateRequiredQueryParametersConduct;
import java.util.Collections;
import java.util.List;

public final class ApiContractImpl implements ApiContract, ApiContract.Definition, ApiContract.Update {
    private ApiContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String sourceApiId() {
        return this.innerModel().sourceApiId();
    }

    public String displayName() {
        return this.innerModel().displayName();
    }

    public String serviceUrl() {
        return this.innerModel().serviceUrl();
    }

    public String path() {
        return this.innerModel().path();
    }

    public List<Protocol> protocols() {
        List<Protocol> inner = this.innerModel().protocols();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public ApiVersionSetContractDetails apiVersionSet() {
        return this.innerModel().apiVersionSet();
    }

    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    public String description() {
        return this.innerModel().description();
    }

    public AuthenticationSettingsContract authenticationSettings() {
        return this.innerModel().authenticationSettings();
    }

    public SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames() {
        return this.innerModel().subscriptionKeyParameterNames();
    }

    public ApiType apiType() {
        return this.innerModel().apiType();
    }

    public String apiRevision() {
        return this.innerModel().apiRevision();
    }

    public String apiVersion() {
        return this.innerModel().apiVersion();
    }

    public Boolean isCurrent() {
        return this.innerModel().isCurrent();
    }

    public Boolean isOnline() {
        return this.innerModel().isOnline();
    }

    public String apiRevisionDescription() {
        return this.innerModel().apiRevisionDescription();
    }

    public String apiVersionDescription() {
        return this.innerModel().apiVersionDescription();
    }

    public String apiVersionSetId() {
        return this.innerModel().apiVersionSetId();
    }

    public Boolean subscriptionRequired() {
        return this.innerModel().subscriptionRequired();
    }

    public String termsOfServiceUrl() {
        return this.innerModel().termsOfServiceUrl();
    }

    public ApiContactInformation contact() {
        return this.innerModel().contact();
    }

    public ApiLicenseInformation license() {
        return this.innerModel().license();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ApiContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String apiId;

    private String createIfMatch;

    private ApiCreateOrUpdateParameter createParameters;

    private String updateIfMatch;

    private ApiUpdateContract updateParameters;

    public ApiContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public ApiContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getApis()
            .createOrUpdate(resourceGroupName, serviceName, apiId, createParameters, createIfMatch, Context.NONE);
        return this;
    }

    public ApiContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApis()
            .createOrUpdate(resourceGroupName, serviceName, apiId, createParameters, createIfMatch, context);
        return this;
    }

    ApiContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new ApiContractInner();
        this.serviceManager = serviceManager;
        this.apiId = name;
        this.createIfMatch = null;
        this.createParameters = new ApiCreateOrUpdateParameter();
    }

    public ApiContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new ApiUpdateContract();
        return this;
    }

    public ApiContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getApis()
            .updateWithResponse(resourceGroupName, serviceName, apiId, updateIfMatch, updateParameters, Context.NONE)
            .getValue();
        return this;
    }

    public ApiContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApis()
            .updateWithResponse(resourceGroupName, serviceName, apiId, updateIfMatch, updateParameters, context)
            .getValue();
        return this;
    }

    ApiContractImpl(ApiContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
    }

    public ApiContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getApis()
            .getWithResponse(resourceGroupName, serviceName, apiId, Context.NONE)
            .getValue();
        return this;
    }

    public ApiContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApis()
            .getWithResponse(resourceGroupName, serviceName, apiId, context)
            .getValue();
        return this;
    }

    public ApiContractImpl withValue(String value) {
        this.createParameters.withValue(value);
        return this;
    }

    public ApiContractImpl withFormat(ContentFormat format) {
        this.createParameters.withFormat(format);
        return this;
    }

    public ApiContractImpl withWsdlSelector(ApiCreateOrUpdatePropertiesWsdlSelector wsdlSelector) {
        this.createParameters.withWsdlSelector(wsdlSelector);
        return this;
    }

    public ApiContractImpl withSoapApiType(SoapApiType soapApiType) {
        this.createParameters.withSoapApiType(soapApiType);
        return this;
    }

    public ApiContractImpl withTranslateRequiredQueryParametersConduct(
        TranslateRequiredQueryParametersConduct translateRequiredQueryParametersConduct) {
        this.createParameters.withTranslateRequiredQueryParametersConduct(translateRequiredQueryParametersConduct);
        return this;
    }

    public ApiContractImpl withSourceApiId(String sourceApiId) {
        this.createParameters.withSourceApiId(sourceApiId);
        return this;
    }

    public ApiContractImpl withDisplayName(String displayName) {
        if (isInCreateMode()) {
            this.createParameters.withDisplayName(displayName);
            return this;
        } else {
            this.updateParameters.withDisplayName(displayName);
            return this;
        }
    }

    public ApiContractImpl withServiceUrl(String serviceUrl) {
        if (isInCreateMode()) {
            this.createParameters.withServiceUrl(serviceUrl);
            return this;
        } else {
            this.updateParameters.withServiceUrl(serviceUrl);
            return this;
        }
    }

    public ApiContractImpl withPath(String path) {
        if (isInCreateMode()) {
            this.createParameters.withPath(path);
            return this;
        } else {
            this.updateParameters.withPath(path);
            return this;
        }
    }

    public ApiContractImpl withProtocols(List<Protocol> protocols) {
        if (isInCreateMode()) {
            this.createParameters.withProtocols(protocols);
            return this;
        } else {
            this.updateParameters.withProtocols(protocols);
            return this;
        }
    }

    public ApiContractImpl withApiVersionSet(ApiVersionSetContractDetails apiVersionSet) {
        this.createParameters.withApiVersionSet(apiVersionSet);
        return this;
    }

    public ApiContractImpl withDescription(String description) {
        if (isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        } else {
            this.updateParameters.withDescription(description);
            return this;
        }
    }

    public ApiContractImpl withAuthenticationSettings(AuthenticationSettingsContract authenticationSettings) {
        if (isInCreateMode()) {
            this.createParameters.withAuthenticationSettings(authenticationSettings);
            return this;
        } else {
            this.updateParameters.withAuthenticationSettings(authenticationSettings);
            return this;
        }
    }

    public ApiContractImpl
        withSubscriptionKeyParameterNames(SubscriptionKeyParameterNamesContract subscriptionKeyParameterNames) {
        if (isInCreateMode()) {
            this.createParameters.withSubscriptionKeyParameterNames(subscriptionKeyParameterNames);
            return this;
        } else {
            this.updateParameters.withSubscriptionKeyParameterNames(subscriptionKeyParameterNames);
            return this;
        }
    }

    public ApiContractImpl withApiType(ApiType apiType) {
        if (isInCreateMode()) {
            this.createParameters.withApiType(apiType);
            return this;
        } else {
            this.updateParameters.withApiType(apiType);
            return this;
        }
    }

    public ApiContractImpl withApiRevision(String apiRevision) {
        if (isInCreateMode()) {
            this.createParameters.withApiRevision(apiRevision);
            return this;
        } else {
            this.updateParameters.withApiRevision(apiRevision);
            return this;
        }
    }

    public ApiContractImpl withApiVersion(String apiVersion) {
        if (isInCreateMode()) {
            this.createParameters.withApiVersion(apiVersion);
            return this;
        } else {
            this.updateParameters.withApiVersion(apiVersion);
            return this;
        }
    }

    public ApiContractImpl withIsCurrent(Boolean isCurrent) {
        if (isInCreateMode()) {
            this.createParameters.withIsCurrent(isCurrent);
            return this;
        } else {
            this.updateParameters.withIsCurrent(isCurrent);
            return this;
        }
    }

    public ApiContractImpl withApiRevisionDescription(String apiRevisionDescription) {
        if (isInCreateMode()) {
            this.createParameters.withApiRevisionDescription(apiRevisionDescription);
            return this;
        } else {
            this.updateParameters.withApiRevisionDescription(apiRevisionDescription);
            return this;
        }
    }

    public ApiContractImpl withApiVersionDescription(String apiVersionDescription) {
        if (isInCreateMode()) {
            this.createParameters.withApiVersionDescription(apiVersionDescription);
            return this;
        } else {
            this.updateParameters.withApiVersionDescription(apiVersionDescription);
            return this;
        }
    }

    public ApiContractImpl withApiVersionSetId(String apiVersionSetId) {
        if (isInCreateMode()) {
            this.createParameters.withApiVersionSetId(apiVersionSetId);
            return this;
        } else {
            this.updateParameters.withApiVersionSetId(apiVersionSetId);
            return this;
        }
    }

    public ApiContractImpl withSubscriptionRequired(Boolean subscriptionRequired) {
        if (isInCreateMode()) {
            this.createParameters.withSubscriptionRequired(subscriptionRequired);
            return this;
        } else {
            this.updateParameters.withSubscriptionRequired(subscriptionRequired);
            return this;
        }
    }

    public ApiContractImpl withTermsOfServiceUrl(String termsOfServiceUrl) {
        if (isInCreateMode()) {
            this.createParameters.withTermsOfServiceUrl(termsOfServiceUrl);
            return this;
        } else {
            this.updateParameters.withTermsOfServiceUrl(termsOfServiceUrl);
            return this;
        }
    }

    public ApiContractImpl withContact(ApiContactInformation contact) {
        if (isInCreateMode()) {
            this.createParameters.withContact(contact);
            return this;
        } else {
            this.updateParameters.withContact(contact);
            return this;
        }
    }

    public ApiContractImpl withLicense(ApiLicenseInformation license) {
        if (isInCreateMode()) {
            this.createParameters.withLicense(license);
            return this;
        } else {
            this.updateParameters.withLicense(license);
            return this;
        }
    }

    public ApiContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
