// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiExportsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiExportResultInner;
import com.azure.resourcemanager.apimanagement.models.ApiExportResult;
import com.azure.resourcemanager.apimanagement.models.ApiExports;
import com.azure.resourcemanager.apimanagement.models.ExportApi;
import com.azure.resourcemanager.apimanagement.models.ExportFormat;

public final class ApiExportsImpl implements ApiExports {
    private static final ClientLogger LOGGER = new ClientLogger(ApiExportsImpl.class);

    private final ApiExportsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiExportsImpl(ApiExportsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<ApiExportResult> getWithResponse(String resourceGroupName, String serviceName, String apiId,
        ExportFormat format, ExportApi export, Context context) {
        Response<ApiExportResultInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, format, export, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiExportResultImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiExportResult get(String resourceGroupName, String serviceName, String apiId, ExportFormat format,
        ExportApi export) {
        ApiExportResultInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, format, export);
        if (inner != null) {
            return new ApiExportResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private ApiExportsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
