// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiGatewayConfigConnectionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayConfigConnectionResourceInner;
import com.azure.resourcemanager.apimanagement.models.ApiGatewayConfigConnections;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayConfigConnectionResource;

public final class ApiGatewayConfigConnectionsImpl implements ApiGatewayConfigConnections {
    private static final ClientLogger LOGGER = new ClientLogger(ApiGatewayConfigConnectionsImpl.class);

    private final ApiGatewayConfigConnectionsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiGatewayConfigConnectionsImpl(ApiGatewayConfigConnectionsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ApiManagementGatewayConfigConnectionResource> listByGateway(String resourceGroupName,
        String gatewayName) {
        PagedIterable<ApiManagementGatewayConfigConnectionResourceInner> inner
            = this.serviceClient().listByGateway(resourceGroupName, gatewayName);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ApiManagementGatewayConfigConnectionResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<ApiManagementGatewayConfigConnectionResource> listByGateway(String resourceGroupName,
        String gatewayName, Context context) {
        PagedIterable<ApiManagementGatewayConfigConnectionResourceInner> inner
            = this.serviceClient().listByGateway(resourceGroupName, gatewayName, context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ApiManagementGatewayConfigConnectionResourceImpl(inner1, this.manager()));
    }

    public Response<ApiManagementGatewayConfigConnectionResource> getWithResponse(String resourceGroupName,
        String gatewayName, String configConnectionName, Context context) {
        Response<ApiManagementGatewayConfigConnectionResourceInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, gatewayName, configConnectionName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiManagementGatewayConfigConnectionResourceImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiManagementGatewayConfigConnectionResource get(String resourceGroupName, String gatewayName,
        String configConnectionName) {
        ApiManagementGatewayConfigConnectionResourceInner inner
            = this.serviceClient().get(resourceGroupName, gatewayName, configConnectionName);
        if (inner != null) {
            return new ApiManagementGatewayConfigConnectionResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName, String gatewayName, String configConnectionName, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, gatewayName, configConnectionName, ifMatch);
    }

    public void delete(String resourceGroupName, String gatewayName, String configConnectionName, String ifMatch,
        Context context) {
        this.serviceClient().delete(resourceGroupName, gatewayName, configConnectionName, ifMatch, context);
    }

    public ApiManagementGatewayConfigConnectionResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String configConnectionName = ResourceManagerUtils.getValueFromIdByName(id, "configConnections");
        if (configConnectionName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'configConnections'.", id)));
        }
        return this.getWithResponse(resourceGroupName, gatewayName, configConnectionName, Context.NONE).getValue();
    }

    public Response<ApiManagementGatewayConfigConnectionResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String configConnectionName = ResourceManagerUtils.getValueFromIdByName(id, "configConnections");
        if (configConnectionName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'configConnections'.", id)));
        }
        return this.getWithResponse(resourceGroupName, gatewayName, configConnectionName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String configConnectionName = ResourceManagerUtils.getValueFromIdByName(id, "configConnections");
        if (configConnectionName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'configConnections'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, gatewayName, configConnectionName, localIfMatch, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String configConnectionName = ResourceManagerUtils.getValueFromIdByName(id, "configConnections");
        if (configConnectionName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'configConnections'.", id)));
        }
        this.delete(resourceGroupName, gatewayName, configConnectionName, ifMatch, context);
    }

    private ApiGatewayConfigConnectionsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public ApiManagementGatewayConfigConnectionResourceImpl define(String name) {
        return new ApiManagementGatewayConfigConnectionResourceImpl(name, this.manager());
    }
}
