// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiGatewaysClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayResourceInner;
import com.azure.resourcemanager.apimanagement.models.ApiGateways;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayResource;

public final class ApiGatewaysImpl implements ApiGateways {
    private static final ClientLogger LOGGER = new ClientLogger(ApiGatewaysImpl.class);

    private final ApiGatewaysClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiGatewaysImpl(ApiGatewaysClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<ApiManagementGatewayResource> getByResourceGroupWithResponse(String resourceGroupName,
        String gatewayName, Context context) {
        Response<ApiManagementGatewayResourceInner> inner
            = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, gatewayName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiManagementGatewayResourceImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiManagementGatewayResource getByResourceGroup(String resourceGroupName, String gatewayName) {
        ApiManagementGatewayResourceInner inner
            = this.serviceClient().getByResourceGroup(resourceGroupName, gatewayName);
        if (inner != null) {
            return new ApiManagementGatewayResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiManagementGatewayResource deleteByResourceGroup(String resourceGroupName, String gatewayName) {
        ApiManagementGatewayResourceInner inner = this.serviceClient().delete(resourceGroupName, gatewayName);
        if (inner != null) {
            return new ApiManagementGatewayResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiManagementGatewayResource delete(String resourceGroupName, String gatewayName, Context context) {
        ApiManagementGatewayResourceInner inner = this.serviceClient().delete(resourceGroupName, gatewayName, context);
        if (inner != null) {
            return new ApiManagementGatewayResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PagedIterable<ApiManagementGatewayResource> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ApiManagementGatewayResourceInner> inner
            = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ApiManagementGatewayResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<ApiManagementGatewayResource> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ApiManagementGatewayResourceInner> inner
            = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ApiManagementGatewayResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<ApiManagementGatewayResource> list() {
        PagedIterable<ApiManagementGatewayResourceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ApiManagementGatewayResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<ApiManagementGatewayResource> list(Context context) {
        PagedIterable<ApiManagementGatewayResourceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ApiManagementGatewayResourceImpl(inner1, this.manager()));
    }

    public ApiManagementGatewayResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, gatewayName, Context.NONE).getValue();
    }

    public Response<ApiManagementGatewayResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, gatewayName, context);
    }

    public ApiManagementGatewayResource deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return this.delete(resourceGroupName, gatewayName, Context.NONE);
    }

    public ApiManagementGatewayResource deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String gatewayName = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return this.delete(resourceGroupName, gatewayName, context);
    }

    private ApiGatewaysClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public ApiManagementGatewayResourceImpl define(String name) {
        return new ApiManagementGatewayResourceImpl(name, this.manager());
    }
}
