// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiIssueAttachmentsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.IssueAttachmentContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiIssueAttachments;
import com.azure.resourcemanager.apimanagement.models.ApiIssueAttachmentsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiIssueAttachmentsGetResponse;
import com.azure.resourcemanager.apimanagement.models.IssueAttachmentContract;

public final class ApiIssueAttachmentsImpl implements ApiIssueAttachments {
    private static final ClientLogger LOGGER = new ClientLogger(ApiIssueAttachmentsImpl.class);

    private final ApiIssueAttachmentsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiIssueAttachmentsImpl(ApiIssueAttachmentsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<IssueAttachmentContract> listByService(String resourceGroupName, String serviceName,
        String apiId, String issueId) {
        PagedIterable<IssueAttachmentContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, apiId, issueId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IssueAttachmentContractImpl(inner1, this.manager()));
    }

    public PagedIterable<IssueAttachmentContract> listByService(String resourceGroupName, String serviceName,
        String apiId, String issueId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<IssueAttachmentContractInner> inner = this.serviceClient()
            .listByService(resourceGroupName, serviceName, apiId, issueId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IssueAttachmentContractImpl(inner1, this.manager()));
    }

    public ApiIssueAttachmentsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName,
        String serviceName, String apiId, String issueId, String attachmentId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String issueId,
        String attachmentId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, issueId, attachmentId);
    }

    public Response<IssueAttachmentContract> getWithResponse(String resourceGroupName, String serviceName, String apiId,
        String issueId, String attachmentId, Context context) {
        ApiIssueAttachmentsGetResponse inner = this.serviceClient()
            .getWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new IssueAttachmentContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public IssueAttachmentContract get(String resourceGroupName, String serviceName, String apiId, String issueId,
        String attachmentId) {
        IssueAttachmentContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, apiId, issueId, attachmentId);
        if (inner != null) {
            return new IssueAttachmentContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String issueId,
        String attachmentId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String apiId, String issueId, String attachmentId,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, issueId, attachmentId, ifMatch);
    }

    public IssueAttachmentContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String attachmentId = ResourceManagerUtils.getValueFromIdByName(id, "attachments");
        if (attachmentId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'attachments'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, Context.NONE)
            .getValue();
    }

    public Response<IssueAttachmentContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String attachmentId = ResourceManagerUtils.getValueFromIdByName(id, "attachments");
        if (attachmentId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'attachments'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String attachmentId = ResourceManagerUtils.getValueFromIdByName(id, "attachments");
        if (attachmentId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'attachments'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, localIfMatch,
            Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String issueId = ResourceManagerUtils.getValueFromIdByName(id, "issues");
        if (issueId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'issues'.", id)));
        }
        String attachmentId = ResourceManagerUtils.getValueFromIdByName(id, "attachments");
        if (attachmentId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'attachments'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, issueId, attachmentId, ifMatch, context);
    }

    private ApiIssueAttachmentsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public IssueAttachmentContractImpl define(String name) {
        return new IssueAttachmentContractImpl(name, this.manager());
    }
}
