// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayConfigConnectionResourceInner;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayConfigConnectionResource;
import java.util.Collections;
import java.util.List;

public final class ApiManagementGatewayConfigConnectionResourceImpl
    implements ApiManagementGatewayConfigConnectionResource, ApiManagementGatewayConfigConnectionResource.Definition,
    ApiManagementGatewayConfigConnectionResource.Update {
    private ApiManagementGatewayConfigConnectionResourceInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String etag() {
        return this.innerModel().etag();
    }

    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    public String sourceId() {
        return this.innerModel().sourceId();
    }

    public String defaultHostname() {
        return this.innerModel().defaultHostname();
    }

    public List<String> hostnames() {
        List<String> inner = this.innerModel().hostnames();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ApiManagementGatewayConfigConnectionResourceInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String gatewayName;

    private String configConnectionName;

    public ApiManagementGatewayConfigConnectionResourceImpl withExistingGateway(String resourceGroupName,
        String gatewayName) {
        this.resourceGroupName = resourceGroupName;
        this.gatewayName = gatewayName;
        return this;
    }

    public ApiManagementGatewayConfigConnectionResource create() {
        this.innerObject = serviceManager.serviceClient()
            .getApiGatewayConfigConnections()
            .createOrUpdate(resourceGroupName, gatewayName, configConnectionName, this.innerModel(), Context.NONE);
        return this;
    }

    public ApiManagementGatewayConfigConnectionResource create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiGatewayConfigConnections()
            .createOrUpdate(resourceGroupName, gatewayName, configConnectionName, this.innerModel(), context);
        return this;
    }

    ApiManagementGatewayConfigConnectionResourceImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new ApiManagementGatewayConfigConnectionResourceInner();
        this.serviceManager = serviceManager;
        this.configConnectionName = name;
    }

    public ApiManagementGatewayConfigConnectionResourceImpl update() {
        return this;
    }

    public ApiManagementGatewayConfigConnectionResource apply() {
        this.innerObject = serviceManager.serviceClient()
            .getApiGatewayConfigConnections()
            .createOrUpdate(resourceGroupName, gatewayName, configConnectionName, this.innerModel(), Context.NONE);
        return this;
    }

    public ApiManagementGatewayConfigConnectionResource apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiGatewayConfigConnections()
            .createOrUpdate(resourceGroupName, gatewayName, configConnectionName, this.innerModel(), context);
        return this;
    }

    ApiManagementGatewayConfigConnectionResourceImpl(ApiManagementGatewayConfigConnectionResourceInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.gatewayName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "gateways");
        this.configConnectionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "configConnections");
    }

    public ApiManagementGatewayConfigConnectionResource refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getApiGatewayConfigConnections()
            .getWithResponse(resourceGroupName, gatewayName, configConnectionName, Context.NONE)
            .getValue();
        return this;
    }

    public ApiManagementGatewayConfigConnectionResource refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiGatewayConfigConnections()
            .getWithResponse(resourceGroupName, gatewayName, configConnectionName, context)
            .getValue();
        return this;
    }

    public ApiManagementGatewayConfigConnectionResourceImpl withSourceId(String sourceId) {
        this.innerModel().withSourceId(sourceId);
        return this;
    }

    public ApiManagementGatewayConfigConnectionResourceImpl withHostnames(List<String> hostnames) {
        this.innerModel().withHostnames(hostnames);
        return this;
    }
}
