// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayResourceInner;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayResource;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewaySkuProperties;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewaySkuPropertiesForPatch;
import com.azure.resourcemanager.apimanagement.models.ApiManagementGatewayUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.BackendConfiguration;
import com.azure.resourcemanager.apimanagement.models.FrontendConfiguration;
import com.azure.resourcemanager.apimanagement.models.GatewayConfigurationApi;
import com.azure.resourcemanager.apimanagement.models.VirtualNetworkType;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class ApiManagementGatewayResourceImpl implements ApiManagementGatewayResource,
    ApiManagementGatewayResource.Definition, ApiManagementGatewayResource.Update {
    private ApiManagementGatewayResourceInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public ApiManagementGatewaySkuProperties sku() {
        return this.innerModel().sku();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public String location() {
        return this.innerModel().location();
    }

    public String etag() {
        return this.innerModel().etag();
    }

    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    public String targetProvisioningState() {
        return this.innerModel().targetProvisioningState();
    }

    public OffsetDateTime createdAtUtc() {
        return this.innerModel().createdAtUtc();
    }

    public FrontendConfiguration frontend() {
        return this.innerModel().frontend();
    }

    public BackendConfiguration backend() {
        return this.innerModel().backend();
    }

    public GatewayConfigurationApi configurationApi() {
        return this.innerModel().configurationApi();
    }

    public VirtualNetworkType virtualNetworkType() {
        return this.innerModel().virtualNetworkType();
    }

    public Region region() {
        return Region.fromName(this.regionName());
    }

    public String regionName() {
        return this.location();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ApiManagementGatewayResourceInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String gatewayName;

    private ApiManagementGatewayUpdateParameters updateParameters;

    public ApiManagementGatewayResourceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public ApiManagementGatewayResource create() {
        this.innerObject = serviceManager.serviceClient()
            .getApiGateways()
            .createOrUpdate(resourceGroupName, gatewayName, this.innerModel(), Context.NONE);
        return this;
    }

    public ApiManagementGatewayResource create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiGateways()
            .createOrUpdate(resourceGroupName, gatewayName, this.innerModel(), context);
        return this;
    }

    ApiManagementGatewayResourceImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new ApiManagementGatewayResourceInner();
        this.serviceManager = serviceManager;
        this.gatewayName = name;
    }

    public ApiManagementGatewayResourceImpl update() {
        this.updateParameters = new ApiManagementGatewayUpdateParameters();
        return this;
    }

    public ApiManagementGatewayResource apply() {
        this.innerObject = serviceManager.serviceClient()
            .getApiGateways()
            .update(resourceGroupName, gatewayName, updateParameters, Context.NONE);
        return this;
    }

    public ApiManagementGatewayResource apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiGateways()
            .update(resourceGroupName, gatewayName, updateParameters, context);
        return this;
    }

    ApiManagementGatewayResourceImpl(ApiManagementGatewayResourceInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.gatewayName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "gateways");
    }

    public ApiManagementGatewayResource refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getApiGateways()
            .getByResourceGroupWithResponse(resourceGroupName, gatewayName, Context.NONE)
            .getValue();
        return this;
    }

    public ApiManagementGatewayResource refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiGateways()
            .getByResourceGroupWithResponse(resourceGroupName, gatewayName, context)
            .getValue();
        return this;
    }

    public ApiManagementGatewayResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    public ApiManagementGatewayResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    public ApiManagementGatewayResourceImpl withSku(ApiManagementGatewaySkuProperties sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    public ApiManagementGatewayResourceImpl withTags(Map<String, String> tags) {
        if (isInCreateMode()) {
            this.innerModel().withTags(tags);
            return this;
        } else {
            this.updateParameters.withTags(tags);
            return this;
        }
    }

    public ApiManagementGatewayResourceImpl withFrontend(FrontendConfiguration frontend) {
        if (isInCreateMode()) {
            this.innerModel().withFrontend(frontend);
            return this;
        } else {
            this.updateParameters.withFrontend(frontend);
            return this;
        }
    }

    public ApiManagementGatewayResourceImpl withBackend(BackendConfiguration backend) {
        if (isInCreateMode()) {
            this.innerModel().withBackend(backend);
            return this;
        } else {
            this.updateParameters.withBackend(backend);
            return this;
        }
    }

    public ApiManagementGatewayResourceImpl withConfigurationApi(GatewayConfigurationApi configurationApi) {
        if (isInCreateMode()) {
            this.innerModel().withConfigurationApi(configurationApi);
            return this;
        } else {
            this.updateParameters.withConfigurationApi(configurationApi);
            return this;
        }
    }

    public ApiManagementGatewayResourceImpl withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        if (isInCreateMode()) {
            this.innerModel().withVirtualNetworkType(virtualNetworkType);
            return this;
        } else {
            this.updateParameters.withVirtualNetworkType(virtualNetworkType);
            return this;
        }
    }

    public ApiManagementGatewayResourceImpl withSku(ApiManagementGatewaySkuPropertiesForPatch sku) {
        this.updateParameters.withSku(sku);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
