// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.apimanagement.fluent.ApiManagementGatewaySkusClient;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayResourceSkuResultInner;
import com.azure.resourcemanager.apimanagement.models.GatewayResourceSkuResults;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ApiManagementGatewaySkusClient.
 */
public final class ApiManagementGatewaySkusClientImpl implements ApiManagementGatewaySkusClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ApiManagementGatewaySkusService service;

    /**
     * The service client containing this operation class.
     */
    private final ApiManagementClientImpl client;

    /**
     * Initializes an instance of ApiManagementGatewaySkusClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ApiManagementGatewaySkusClientImpl(ApiManagementClientImpl client) {
        this.service = RestProxy.create(ApiManagementGatewaySkusService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ApiManagementClientApiManagementGatewaySkus to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ApiManagementClientA")
    public interface ApiManagementGatewaySkusService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/gateways/{gatewayName}/skus")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GatewayResourceSkuResults>> listAvailableSkus(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("gatewayName") String gatewayName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GatewayResourceSkuResults>> listAvailableSkusNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets available SKUs for API Management gateway
     * 
     * Gets all available SKU for a given API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all available SKU for a given API Management gateway along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GatewayResourceSkuResultInner>>
        listAvailableSkusSinglePageAsync(String resourceGroupName, String gatewayName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (gatewayName == null) {
            return Mono.error(new IllegalArgumentException("Parameter gatewayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAvailableSkus(this.client.getEndpoint(), resourceGroupName, gatewayName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<GatewayResourceSkuResultInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets available SKUs for API Management gateway
     * 
     * Gets all available SKU for a given API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all available SKU for a given API Management gateway along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GatewayResourceSkuResultInner>>
        listAvailableSkusSinglePageAsync(String resourceGroupName, String gatewayName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (gatewayName == null) {
            return Mono.error(new IllegalArgumentException("Parameter gatewayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listAvailableSkus(this.client.getEndpoint(), resourceGroupName, gatewayName, this.client.getApiVersion(),
                this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets available SKUs for API Management gateway
     * 
     * Gets all available SKU for a given API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all available SKU for a given API Management gateway as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GatewayResourceSkuResultInner> listAvailableSkusAsync(String resourceGroupName,
        String gatewayName) {
        return new PagedFlux<>(() -> listAvailableSkusSinglePageAsync(resourceGroupName, gatewayName),
            nextLink -> listAvailableSkusNextSinglePageAsync(nextLink));
    }

    /**
     * Gets available SKUs for API Management gateway
     * 
     * Gets all available SKU for a given API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all available SKU for a given API Management gateway as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GatewayResourceSkuResultInner> listAvailableSkusAsync(String resourceGroupName,
        String gatewayName, Context context) {
        return new PagedFlux<>(() -> listAvailableSkusSinglePageAsync(resourceGroupName, gatewayName, context),
            nextLink -> listAvailableSkusNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets available SKUs for API Management gateway
     * 
     * Gets all available SKU for a given API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all available SKU for a given API Management gateway as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GatewayResourceSkuResultInner> listAvailableSkus(String resourceGroupName,
        String gatewayName) {
        return new PagedIterable<>(listAvailableSkusAsync(resourceGroupName, gatewayName));
    }

    /**
     * Gets available SKUs for API Management gateway
     * 
     * Gets all available SKU for a given API Management gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all available SKU for a given API Management gateway as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GatewayResourceSkuResultInner> listAvailableSkus(String resourceGroupName, String gatewayName,
        Context context) {
        return new PagedIterable<>(listAvailableSkusAsync(resourceGroupName, gatewayName, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the API Management gateway SKUs operation response along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GatewayResourceSkuResultInner>> listAvailableSkusNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAvailableSkusNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<GatewayResourceSkuResultInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the API Management gateway SKUs operation response along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GatewayResourceSkuResultInner>> listAvailableSkusNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAvailableSkusNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
