// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiManagementServicesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceGetDomainOwnershipIdentifierResultInner;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceGetSsoTokenResultInner;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceNameAvailabilityResultInner;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementServiceResourceInner;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceApplyNetworkConfigurationParameters;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceBackupRestoreParameters;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceCheckNameAvailabilityParameters;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceGetDomainOwnershipIdentifierResult;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceGetSsoTokenResult;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceNameAvailabilityResult;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServiceResource;
import com.azure.resourcemanager.apimanagement.models.ApiManagementServices;
import com.azure.resourcemanager.apimanagement.models.MigrateToStv2Contract;

public final class ApiManagementServicesImpl implements ApiManagementServices {
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementServicesImpl.class);

    private final ApiManagementServicesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiManagementServicesImpl(ApiManagementServicesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public ApiManagementServiceResource restore(String resourceGroupName, String serviceName,
        ApiManagementServiceBackupRestoreParameters parameters) {
        ApiManagementServiceResourceInner inner
            = this.serviceClient().restore(resourceGroupName, serviceName, parameters);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiManagementServiceResource restore(String resourceGroupName, String serviceName,
        ApiManagementServiceBackupRestoreParameters parameters, Context context) {
        ApiManagementServiceResourceInner inner
            = this.serviceClient().restore(resourceGroupName, serviceName, parameters, context);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiManagementServiceResource backup(String resourceGroupName, String serviceName,
        ApiManagementServiceBackupRestoreParameters parameters) {
        ApiManagementServiceResourceInner inner
            = this.serviceClient().backup(resourceGroupName, serviceName, parameters);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiManagementServiceResource backup(String resourceGroupName, String serviceName,
        ApiManagementServiceBackupRestoreParameters parameters, Context context) {
        ApiManagementServiceResourceInner inner
            = this.serviceClient().backup(resourceGroupName, serviceName, parameters, context);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ApiManagementServiceResource> getByResourceGroupWithResponse(String resourceGroupName,
        String serviceName, Context context) {
        Response<ApiManagementServiceResourceInner> inner
            = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiManagementServiceResourceImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiManagementServiceResource getByResourceGroup(String resourceGroupName, String serviceName) {
        ApiManagementServiceResourceInner inner
            = this.serviceClient().getByResourceGroup(resourceGroupName, serviceName);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiManagementServiceResource deleteByResourceGroup(String resourceGroupName, String serviceName) {
        ApiManagementServiceResourceInner inner = this.serviceClient().delete(resourceGroupName, serviceName);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiManagementServiceResource delete(String resourceGroupName, String serviceName, Context context) {
        ApiManagementServiceResourceInner inner = this.serviceClient().delete(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiManagementServiceResource migrateToStv2(String resourceGroupName, String serviceName) {
        ApiManagementServiceResourceInner inner = this.serviceClient().migrateToStv2(resourceGroupName, serviceName);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiManagementServiceResource migrateToStv2(String resourceGroupName, String serviceName,
        MigrateToStv2Contract parameters, Context context) {
        ApiManagementServiceResourceInner inner
            = this.serviceClient().migrateToStv2(resourceGroupName, serviceName, parameters, context);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PagedIterable<ApiManagementServiceResource> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ApiManagementServiceResourceInner> inner
            = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ApiManagementServiceResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<ApiManagementServiceResource> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ApiManagementServiceResourceInner> inner
            = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ApiManagementServiceResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<ApiManagementServiceResource> list() {
        PagedIterable<ApiManagementServiceResourceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ApiManagementServiceResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<ApiManagementServiceResource> list(Context context) {
        PagedIterable<ApiManagementServiceResourceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ApiManagementServiceResourceImpl(inner1, this.manager()));
    }

    public Response<ApiManagementServiceGetSsoTokenResult> getSsoTokenWithResponse(String resourceGroupName,
        String serviceName, Context context) {
        Response<ApiManagementServiceGetSsoTokenResultInner> inner
            = this.serviceClient().getSsoTokenWithResponse(resourceGroupName, serviceName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiManagementServiceGetSsoTokenResultImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiManagementServiceGetSsoTokenResult getSsoToken(String resourceGroupName, String serviceName) {
        ApiManagementServiceGetSsoTokenResultInner inner
            = this.serviceClient().getSsoToken(resourceGroupName, serviceName);
        if (inner != null) {
            return new ApiManagementServiceGetSsoTokenResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ApiManagementServiceNameAvailabilityResult> checkNameAvailabilityWithResponse(
        ApiManagementServiceCheckNameAvailabilityParameters parameters, Context context) {
        Response<ApiManagementServiceNameAvailabilityResultInner> inner
            = this.serviceClient().checkNameAvailabilityWithResponse(parameters, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiManagementServiceNameAvailabilityResultImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiManagementServiceNameAvailabilityResult
        checkNameAvailability(ApiManagementServiceCheckNameAvailabilityParameters parameters) {
        ApiManagementServiceNameAvailabilityResultInner inner = this.serviceClient().checkNameAvailability(parameters);
        if (inner != null) {
            return new ApiManagementServiceNameAvailabilityResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ApiManagementServiceGetDomainOwnershipIdentifierResult>
        getDomainOwnershipIdentifierWithResponse(Context context) {
        Response<ApiManagementServiceGetDomainOwnershipIdentifierResultInner> inner
            = this.serviceClient().getDomainOwnershipIdentifierWithResponse(context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiManagementServiceGetDomainOwnershipIdentifierResultImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiManagementServiceGetDomainOwnershipIdentifierResult getDomainOwnershipIdentifier() {
        ApiManagementServiceGetDomainOwnershipIdentifierResultInner inner
            = this.serviceClient().getDomainOwnershipIdentifier();
        if (inner != null) {
            return new ApiManagementServiceGetDomainOwnershipIdentifierResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiManagementServiceResource applyNetworkConfigurationUpdates(String resourceGroupName, String serviceName) {
        ApiManagementServiceResourceInner inner
            = this.serviceClient().applyNetworkConfigurationUpdates(resourceGroupName, serviceName);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiManagementServiceResource applyNetworkConfigurationUpdates(String resourceGroupName, String serviceName,
        ApiManagementServiceApplyNetworkConfigurationParameters parameters, Context context) {
        ApiManagementServiceResourceInner inner = this.serviceClient()
            .applyNetworkConfigurationUpdates(resourceGroupName, serviceName, parameters, context);
        if (inner != null) {
            return new ApiManagementServiceResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiManagementServiceResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, serviceName, Context.NONE).getValue();
    }

    public Response<ApiManagementServiceResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, serviceName, context);
    }

    public ApiManagementServiceResource deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        return this.delete(resourceGroupName, serviceName, Context.NONE);
    }

    public ApiManagementServiceResource deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        return this.delete(resourceGroupName, serviceName, context);
    }

    private ApiManagementServicesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public ApiManagementServiceResourceImpl define(String name) {
        return new ApiManagementServiceResourceImpl(name, this.manager());
    }
}
