// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementSkuInner;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSku;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkuCapabilities;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkuCapacity;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkuCosts;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkuLocationInfo;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkuRestrictions;
import java.util.Collections;
import java.util.List;

public final class ApiManagementSkuImpl implements ApiManagementSku {
    private ApiManagementSkuInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    ApiManagementSkuImpl(ApiManagementSkuInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String resourceType() {
        return this.innerModel().resourceType();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String tier() {
        return this.innerModel().tier();
    }

    public String size() {
        return this.innerModel().size();
    }

    public String family() {
        return this.innerModel().family();
    }

    public String kind() {
        return this.innerModel().kind();
    }

    public ApiManagementSkuCapacity capacity() {
        return this.innerModel().capacity();
    }

    public List<String> locations() {
        List<String> inner = this.innerModel().locations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<ApiManagementSkuLocationInfo> locationInfo() {
        List<ApiManagementSkuLocationInfo> inner = this.innerModel().locationInfo();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<String> apiVersions() {
        List<String> inner = this.innerModel().apiVersions();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<ApiManagementSkuCosts> costs() {
        List<ApiManagementSkuCosts> inner = this.innerModel().costs();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<ApiManagementSkuCapabilities> capabilities() {
        List<ApiManagementSkuCapabilities> inner = this.innerModel().capabilities();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<ApiManagementSkuRestrictions> restrictions() {
        List<ApiManagementSkuRestrictions> inner = this.innerModel().restrictions();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public ApiManagementSkuInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
