// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiManagementSkusClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementSkuInner;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSku;
import com.azure.resourcemanager.apimanagement.models.ApiManagementSkus;

public final class ApiManagementSkusImpl implements ApiManagementSkus {
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementSkusImpl.class);

    private final ApiManagementSkusClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiManagementSkusImpl(ApiManagementSkusClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ApiManagementSku> list() {
        PagedIterable<ApiManagementSkuInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementSkuImpl(inner1, this.manager()));
    }

    public PagedIterable<ApiManagementSku> list(Context context) {
        PagedIterable<ApiManagementSkuInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiManagementSkuImpl(inner1, this.manager()));
    }

    private ApiManagementSkusClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
