// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiManagementWorkspaceLinkOperationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementWorkspaceLinksResourceInner;
import com.azure.resourcemanager.apimanagement.models.ApiManagementWorkspaceLinkOperations;
import com.azure.resourcemanager.apimanagement.models.ApiManagementWorkspaceLinksResource;

public final class ApiManagementWorkspaceLinkOperationsImpl implements ApiManagementWorkspaceLinkOperations {
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementWorkspaceLinkOperationsImpl.class);

    private final ApiManagementWorkspaceLinkOperationsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiManagementWorkspaceLinkOperationsImpl(ApiManagementWorkspaceLinkOperationsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<ApiManagementWorkspaceLinksResource> getWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, Context context) {
        Response<ApiManagementWorkspaceLinksResourceInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiManagementWorkspaceLinksResourceImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiManagementWorkspaceLinksResource get(String resourceGroupName, String serviceName, String workspaceId) {
        ApiManagementWorkspaceLinksResourceInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, workspaceId);
        if (inner != null) {
            return new ApiManagementWorkspaceLinksResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private ApiManagementWorkspaceLinkOperationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
