// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiManagementWorkspaceLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementWorkspaceLinksResourceInner;
import com.azure.resourcemanager.apimanagement.models.ApiManagementWorkspaceLinks;
import com.azure.resourcemanager.apimanagement.models.ApiManagementWorkspaceLinksResource;

public final class ApiManagementWorkspaceLinksImpl implements ApiManagementWorkspaceLinks {
    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementWorkspaceLinksImpl.class);

    private final ApiManagementWorkspaceLinksClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiManagementWorkspaceLinksImpl(ApiManagementWorkspaceLinksClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ApiManagementWorkspaceLinksResource> listByService(String resourceGroupName,
        String serviceName) {
        PagedIterable<ApiManagementWorkspaceLinksResourceInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ApiManagementWorkspaceLinksResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<ApiManagementWorkspaceLinksResource> listByService(String resourceGroupName,
        String serviceName, Context context) {
        PagedIterable<ApiManagementWorkspaceLinksResourceInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ApiManagementWorkspaceLinksResourceImpl(inner1, this.manager()));
    }

    private ApiManagementWorkspaceLinksClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
