// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementWorkspaceLinksResourceInner;
import com.azure.resourcemanager.apimanagement.models.ApiManagementWorkspaceLinksResource;
import com.azure.resourcemanager.apimanagement.models.WorkspaceLinksGateway;
import java.util.Collections;
import java.util.List;

public final class ApiManagementWorkspaceLinksResourceImpl implements ApiManagementWorkspaceLinksResource {
    private ApiManagementWorkspaceLinksResourceInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    ApiManagementWorkspaceLinksResourceImpl(ApiManagementWorkspaceLinksResourceInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String etag() {
        return this.innerModel().etag();
    }

    public String workspaceId() {
        return this.innerModel().workspaceId();
    }

    public List<WorkspaceLinksGateway> gateways() {
        List<WorkspaceLinksGateway> inner = this.innerModel().gateways();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public ApiManagementWorkspaceLinksResourceInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
