// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiOperationPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyCollectionInner;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiOperationPolicies;
import com.azure.resourcemanager.apimanagement.models.ApiOperationPoliciesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiOperationPoliciesGetResponse;
import com.azure.resourcemanager.apimanagement.models.PolicyCollection;
import com.azure.resourcemanager.apimanagement.models.PolicyContract;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;

public final class ApiOperationPoliciesImpl implements ApiOperationPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(ApiOperationPoliciesImpl.class);

    private final ApiOperationPoliciesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiOperationPoliciesImpl(ApiOperationPoliciesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<PolicyCollection> listByOperationWithResponse(String resourceGroupName, String serviceName,
        String apiId, String operationId, Context context) {
        Response<PolicyCollectionInner> inner = this.serviceClient()
            .listByOperationWithResponse(resourceGroupName, serviceName, apiId, operationId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PolicyCollectionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PolicyCollection listByOperation(String resourceGroupName, String serviceName, String apiId,
        String operationId) {
        PolicyCollectionInner inner
            = this.serviceClient().listByOperation(resourceGroupName, serviceName, apiId, operationId);
        if (inner != null) {
            return new PolicyCollectionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiOperationPoliciesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName,
        String serviceName, String apiId, String operationId, PolicyIdName policyId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String operationId,
        PolicyIdName policyId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, operationId, policyId);
    }

    public Response<PolicyContract> getWithResponse(String resourceGroupName, String serviceName, String apiId,
        String operationId, PolicyIdName policyId, PolicyExportFormat format, Context context) {
        ApiOperationPoliciesGetResponse inner = this.serviceClient()
            .getWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, format, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PolicyContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PolicyContract get(String resourceGroupName, String serviceName, String apiId, String operationId,
        PolicyIdName policyId) {
        PolicyContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, apiId, operationId, policyId);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId,
        String operationId, PolicyIdName policyId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String apiId, String operationId,
        PolicyIdName policyId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, operationId, policyId, ifMatch);
    }

    public PolicyContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String operationId = ResourceManagerUtils.getValueFromIdByName(id, "operations");
        if (operationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'operations'.", id)));
        }
        String policyIdLocal = ResourceManagerUtils.getValueFromIdByName(id, "policies");
        if (policyIdLocal == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'policies'.", id)));
        }
        PolicyIdName policyId = PolicyIdName.fromString(policyIdLocal);
        PolicyExportFormat localFormat = null;
        return this
            .getWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, localFormat, Context.NONE)
            .getValue();
    }

    public Response<PolicyContract> getByIdWithResponse(String id, PolicyExportFormat format, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String operationId = ResourceManagerUtils.getValueFromIdByName(id, "operations");
        if (operationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'operations'.", id)));
        }
        String policyIdLocal = ResourceManagerUtils.getValueFromIdByName(id, "policies");
        if (policyIdLocal == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'policies'.", id)));
        }
        PolicyIdName policyId = PolicyIdName.fromString(policyIdLocal);
        return this.getWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, format, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String operationId = ResourceManagerUtils.getValueFromIdByName(id, "operations");
        if (operationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'operations'.", id)));
        }
        String policyIdLocal = ResourceManagerUtils.getValueFromIdByName(id, "policies");
        if (policyIdLocal == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'policies'.", id)));
        }
        PolicyIdName policyId = PolicyIdName.fromString(policyIdLocal);
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, localIfMatch,
            Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String operationId = ResourceManagerUtils.getValueFromIdByName(id, "operations");
        if (operationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'operations'.", id)));
        }
        String policyIdLocal = ResourceManagerUtils.getValueFromIdByName(id, "policies");
        if (policyIdLocal == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'policies'.", id)));
        }
        PolicyIdName policyId = PolicyIdName.fromString(policyIdLocal);
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, operationId, policyId, ifMatch, context);
    }

    private ApiOperationPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public PolicyContractImpl define(PolicyIdName name) {
        return new PolicyContractImpl(name, this.manager());
    }
}
