// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiOperationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.OperationContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiOperations;
import com.azure.resourcemanager.apimanagement.models.ApiOperationsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiOperationsGetResponse;
import com.azure.resourcemanager.apimanagement.models.OperationContract;

public final class ApiOperationsImpl implements ApiOperations {
    private static final ClientLogger LOGGER = new ClientLogger(ApiOperationsImpl.class);

    private final ApiOperationsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiOperationsImpl(ApiOperationsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<OperationContract> listByApi(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<OperationContractInner> inner
            = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationContractImpl(inner1, this.manager()));
    }

    public PagedIterable<OperationContract> listByApi(String resourceGroupName, String serviceName, String apiId,
        String filter, Integer top, Integer skip, String tags, Context context) {
        PagedIterable<OperationContractInner> inner
            = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId, filter, top, skip, tags, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationContractImpl(inner1, this.manager()));
    }

    public ApiOperationsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String apiId, String operationId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, apiId, operationId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String operationId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, operationId);
    }

    public Response<OperationContract> getWithResponse(String resourceGroupName, String serviceName, String apiId,
        String operationId, Context context) {
        ApiOperationsGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, operationId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new OperationContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public OperationContract get(String resourceGroupName, String serviceName, String apiId, String operationId) {
        OperationContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, operationId);
        if (inner != null) {
            return new OperationContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId,
        String operationId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, apiId, operationId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String apiId, String operationId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, operationId, ifMatch);
    }

    public OperationContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String operationId = ResourceManagerUtils.getValueFromIdByName(id, "operations");
        if (operationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'operations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, operationId, Context.NONE).getValue();
    }

    public Response<OperationContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String operationId = ResourceManagerUtils.getValueFromIdByName(id, "operations");
        if (operationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'operations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, operationId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String operationId = ResourceManagerUtils.getValueFromIdByName(id, "operations");
        if (operationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'operations'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, operationId, localIfMatch, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String operationId = ResourceManagerUtils.getValueFromIdByName(id, "operations");
        if (operationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'operations'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, operationId, ifMatch, context);
    }

    private ApiOperationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public OperationContractImpl define(String name) {
        return new OperationContractImpl(name, this.manager());
    }
}
