// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyCollectionInner;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiPolicies;
import com.azure.resourcemanager.apimanagement.models.ApiPoliciesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.ApiPoliciesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiPoliciesGetResponse;
import com.azure.resourcemanager.apimanagement.models.PolicyCollection;
import com.azure.resourcemanager.apimanagement.models.PolicyContract;
import com.azure.resourcemanager.apimanagement.models.PolicyExportFormat;
import com.azure.resourcemanager.apimanagement.models.PolicyIdName;

public final class ApiPoliciesImpl implements ApiPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(ApiPoliciesImpl.class);

    private final ApiPoliciesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiPoliciesImpl(ApiPoliciesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<PolicyCollection> listByApiWithResponse(String resourceGroupName, String serviceName, String apiId,
        Context context) {
        Response<PolicyCollectionInner> inner
            = this.serviceClient().listByApiWithResponse(resourceGroupName, serviceName, apiId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PolicyCollectionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PolicyCollection listByApi(String resourceGroupName, String serviceName, String apiId) {
        PolicyCollectionInner inner = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId);
        if (inner != null) {
            return new PolicyCollectionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ApiPoliciesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String apiId, PolicyIdName policyId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, policyId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, PolicyIdName policyId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, policyId);
    }

    public Response<PolicyContract> getWithResponse(String resourceGroupName, String serviceName, String apiId,
        PolicyIdName policyId, PolicyExportFormat format, Context context) {
        ApiPoliciesGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, policyId, format, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PolicyContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PolicyContract get(String resourceGroupName, String serviceName, String apiId, PolicyIdName policyId) {
        PolicyContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, policyId);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<PolicyContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String apiId, PolicyIdName policyId, PolicyContractInner parameters, String ifMatch, Context context) {
        ApiPoliciesCreateOrUpdateResponse inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, policyId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PolicyContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PolicyContract createOrUpdate(String resourceGroupName, String serviceName, String apiId,
        PolicyIdName policyId, PolicyContractInner parameters) {
        PolicyContractInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, apiId, policyId, parameters);
        if (inner != null) {
            return new PolicyContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId,
        PolicyIdName policyId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, apiId, policyId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String apiId, PolicyIdName policyId,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, policyId, ifMatch);
    }

    private ApiPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
