// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiReleaseContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiReleaseContract;
import java.time.OffsetDateTime;

public final class ApiReleaseContractImpl
    implements ApiReleaseContract, ApiReleaseContract.Definition, ApiReleaseContract.Update {
    private ApiReleaseContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String apiId() {
        return this.innerModel().apiId();
    }

    public OffsetDateTime createdDateTime() {
        return this.innerModel().createdDateTime();
    }

    public OffsetDateTime updatedDateTime() {
        return this.innerModel().updatedDateTime();
    }

    public String notes() {
        return this.innerModel().notes();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ApiReleaseContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String apiId;

    private String releaseId;

    private String createIfMatch;

    private String updateIfMatch;

    public ApiReleaseContractImpl withExistingApi(String resourceGroupName, String serviceName, String apiId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.apiId = apiId;
        return this;
    }

    public ApiReleaseContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getApiReleases()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, releaseId, this.innerModel(),
                createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public ApiReleaseContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiReleases()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, releaseId, this.innerModel(),
                createIfMatch, context)
            .getValue();
        return this;
    }

    ApiReleaseContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new ApiReleaseContractInner();
        this.serviceManager = serviceManager;
        this.releaseId = name;
        this.createIfMatch = null;
    }

    public ApiReleaseContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public ApiReleaseContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getApiReleases()
            .updateWithResponse(resourceGroupName, serviceName, apiId, releaseId, updateIfMatch, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public ApiReleaseContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiReleases()
            .updateWithResponse(resourceGroupName, serviceName, apiId, releaseId, updateIfMatch, this.innerModel(),
                context)
            .getValue();
        return this;
    }

    ApiReleaseContractImpl(ApiReleaseContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.apiId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apis");
        this.releaseId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "releases");
    }

    public ApiReleaseContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getApiReleases()
            .getWithResponse(resourceGroupName, serviceName, apiId, releaseId, Context.NONE)
            .getValue();
        return this;
    }

    public ApiReleaseContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiReleases()
            .getWithResponse(resourceGroupName, serviceName, apiId, releaseId, context)
            .getValue();
        return this;
    }

    public ApiReleaseContractImpl withApiId(String apiId) {
        this.innerModel().withApiId(apiId);
        return this;
    }

    public ApiReleaseContractImpl withNotes(String notes) {
        this.innerModel().withNotes(notes);
        return this;
    }

    public ApiReleaseContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
