// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiReleasesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiReleaseContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiReleaseContract;
import com.azure.resourcemanager.apimanagement.models.ApiReleases;
import com.azure.resourcemanager.apimanagement.models.ApiReleasesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiReleasesGetResponse;

public final class ApiReleasesImpl implements ApiReleases {
    private static final ClientLogger LOGGER = new ClientLogger(ApiReleasesImpl.class);

    private final ApiReleasesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiReleasesImpl(ApiReleasesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ApiReleaseContract> listByService(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<ApiReleaseContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiReleaseContractImpl(inner1, this.manager()));
    }

    public PagedIterable<ApiReleaseContract> listByService(String resourceGroupName, String serviceName, String apiId,
        String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ApiReleaseContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, apiId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiReleaseContractImpl(inner1, this.manager()));
    }

    public ApiReleasesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String apiId, String releaseId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, releaseId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String releaseId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, releaseId);
    }

    public Response<ApiReleaseContract> getWithResponse(String resourceGroupName, String serviceName, String apiId,
        String releaseId, Context context) {
        ApiReleasesGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, releaseId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ApiReleaseContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApiReleaseContract get(String resourceGroupName, String serviceName, String apiId, String releaseId) {
        ApiReleaseContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, releaseId);
        if (inner != null) {
            return new ApiReleaseContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId,
        String releaseId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, apiId, releaseId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String apiId, String releaseId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, releaseId, ifMatch);
    }

    public ApiReleaseContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String releaseId = ResourceManagerUtils.getValueFromIdByName(id, "releases");
        if (releaseId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'releases'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, releaseId, Context.NONE).getValue();
    }

    public Response<ApiReleaseContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String releaseId = ResourceManagerUtils.getValueFromIdByName(id, "releases");
        if (releaseId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'releases'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, releaseId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String releaseId = ResourceManagerUtils.getValueFromIdByName(id, "releases");
        if (releaseId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'releases'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, releaseId, localIfMatch, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String releaseId = ResourceManagerUtils.getValueFromIdByName(id, "releases");
        if (releaseId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'releases'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, releaseId, ifMatch, context);
    }

    private ApiReleasesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public ApiReleaseContractImpl define(String name) {
        return new ApiReleaseContractImpl(name, this.manager());
    }
}
