// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiSchemasClient;
import com.azure.resourcemanager.apimanagement.fluent.models.SchemaContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiSchemas;
import com.azure.resourcemanager.apimanagement.models.ApiSchemasGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiSchemasGetResponse;
import com.azure.resourcemanager.apimanagement.models.SchemaContract;

public final class ApiSchemasImpl implements ApiSchemas {
    private static final ClientLogger LOGGER = new ClientLogger(ApiSchemasImpl.class);

    private final ApiSchemasClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiSchemasImpl(ApiSchemasClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<SchemaContract> listByApi(String resourceGroupName, String serviceName, String apiId) {
        PagedIterable<SchemaContractInner> inner
            = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaContractImpl(inner1, this.manager()));
    }

    public PagedIterable<SchemaContract> listByApi(String resourceGroupName, String serviceName, String apiId,
        String filter, Integer top, Integer skip, Context context) {
        PagedIterable<SchemaContractInner> inner
            = this.serviceClient().listByApi(resourceGroupName, serviceName, apiId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchemaContractImpl(inner1, this.manager()));
    }

    public ApiSchemasGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String apiId, String schemaId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, schemaId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String schemaId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, schemaId);
    }

    public Response<SchemaContract> getWithResponse(String resourceGroupName, String serviceName, String apiId,
        String schemaId, Context context) {
        ApiSchemasGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, schemaId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new SchemaContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public SchemaContract get(String resourceGroupName, String serviceName, String apiId, String schemaId) {
        SchemaContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId, schemaId);
        if (inner != null) {
            return new SchemaContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId,
        String schemaId, String ifMatch, Boolean force, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, apiId, schemaId, ifMatch, force, context);
    }

    public void delete(String resourceGroupName, String serviceName, String apiId, String schemaId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, schemaId, ifMatch);
    }

    public SchemaContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String schemaId = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, schemaId, Context.NONE).getValue();
    }

    public Response<SchemaContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String schemaId = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, schemaId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String schemaId = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String localIfMatch = null;
        Boolean localForce = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, schemaId, localIfMatch, localForce,
            Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Boolean force, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String schemaId = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, schemaId, ifMatch, force, context);
    }

    private ApiSchemasClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public SchemaContractImpl define(String name) {
        return new SchemaContractImpl(name, this.manager());
    }
}
