// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiTagDescriptionsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.TagDescriptionContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiTagDescriptions;
import com.azure.resourcemanager.apimanagement.models.ApiTagDescriptionsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiTagDescriptionsGetResponse;
import com.azure.resourcemanager.apimanagement.models.TagDescriptionContract;

public final class ApiTagDescriptionsImpl implements ApiTagDescriptions {
    private static final ClientLogger LOGGER = new ClientLogger(ApiTagDescriptionsImpl.class);

    private final ApiTagDescriptionsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiTagDescriptionsImpl(ApiTagDescriptionsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<TagDescriptionContract> listByService(String resourceGroupName, String serviceName,
        String apiId) {
        PagedIterable<TagDescriptionContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, apiId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagDescriptionContractImpl(inner1, this.manager()));
    }

    public PagedIterable<TagDescriptionContract> listByService(String resourceGroupName, String serviceName,
        String apiId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<TagDescriptionContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, apiId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TagDescriptionContractImpl(inner1, this.manager()));
    }

    public ApiTagDescriptionsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String apiId, String tagDescriptionId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String apiId, String tagDescriptionId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId, tagDescriptionId);
    }

    public Response<TagDescriptionContract> getWithResponse(String resourceGroupName, String serviceName, String apiId,
        String tagDescriptionId, Context context) {
        ApiTagDescriptionsGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new TagDescriptionContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public TagDescriptionContract get(String resourceGroupName, String serviceName, String apiId,
        String tagDescriptionId) {
        TagDescriptionContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, apiId, tagDescriptionId);
        if (inner != null) {
            return new TagDescriptionContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId,
        String tagDescriptionId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String apiId, String tagDescriptionId,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, tagDescriptionId, ifMatch);
    }

    public TagDescriptionContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String tagDescriptionId = ResourceManagerUtils.getValueFromIdByName(id, "tagDescriptions");
        if (tagDescriptionId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'tagDescriptions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, Context.NONE).getValue();
    }

    public Response<TagDescriptionContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String tagDescriptionId = ResourceManagerUtils.getValueFromIdByName(id, "tagDescriptions");
        if (tagDescriptionId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'tagDescriptions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String tagDescriptionId = ResourceManagerUtils.getValueFromIdByName(id, "tagDescriptions");
        if (tagDescriptionId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'tagDescriptions'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, localIfMatch, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String apiId = ResourceManagerUtils.getValueFromIdByName(id, "apis");
        if (apiId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'apis'.", id)));
        }
        String tagDescriptionId = ResourceManagerUtils.getValueFromIdByName(id, "tagDescriptions");
        if (tagDescriptionId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'tagDescriptions'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, apiId, tagDescriptionId, ifMatch, context);
    }

    private ApiTagDescriptionsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public TagDescriptionContractImpl define(String name) {
        return new TagDescriptionContractImpl(name, this.manager());
    }
}
