// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiVersionSetContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetContract;
import com.azure.resourcemanager.apimanagement.models.ApiVersionSetUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.VersioningScheme;

public final class ApiVersionSetContractImpl
    implements ApiVersionSetContract, ApiVersionSetContract.Definition, ApiVersionSetContract.Update {
    private ApiVersionSetContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String displayName() {
        return this.innerModel().displayName();
    }

    public VersioningScheme versioningScheme() {
        return this.innerModel().versioningScheme();
    }

    public String description() {
        return this.innerModel().description();
    }

    public String versionQueryName() {
        return this.innerModel().versionQueryName();
    }

    public String versionHeaderName() {
        return this.innerModel().versionHeaderName();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ApiVersionSetContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String versionSetId;

    private String createIfMatch;

    private String updateIfMatch;

    private ApiVersionSetUpdateParameters updateParameters;

    public ApiVersionSetContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public ApiVersionSetContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getApiVersionSets()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, versionSetId, this.innerModel(), createIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public ApiVersionSetContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiVersionSets()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, versionSetId, this.innerModel(), createIfMatch,
                context)
            .getValue();
        return this;
    }

    ApiVersionSetContractImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new ApiVersionSetContractInner();
        this.serviceManager = serviceManager;
        this.versionSetId = name;
        this.createIfMatch = null;
    }

    public ApiVersionSetContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new ApiVersionSetUpdateParameters();
        return this;
    }

    public ApiVersionSetContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getApiVersionSets()
            .updateWithResponse(resourceGroupName, serviceName, versionSetId, updateIfMatch, updateParameters,
                Context.NONE)
            .getValue();
        return this;
    }

    public ApiVersionSetContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiVersionSets()
            .updateWithResponse(resourceGroupName, serviceName, versionSetId, updateIfMatch, updateParameters, context)
            .getValue();
        return this;
    }

    ApiVersionSetContractImpl(ApiVersionSetContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.versionSetId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "apiVersionSets");
    }

    public ApiVersionSetContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getApiVersionSets()
            .getWithResponse(resourceGroupName, serviceName, versionSetId, Context.NONE)
            .getValue();
        return this;
    }

    public ApiVersionSetContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getApiVersionSets()
            .getWithResponse(resourceGroupName, serviceName, versionSetId, context)
            .getValue();
        return this;
    }

    public ApiVersionSetContractImpl withDisplayName(String displayName) {
        if (isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        } else {
            this.updateParameters.withDisplayName(displayName);
            return this;
        }
    }

    public ApiVersionSetContractImpl withVersioningScheme(VersioningScheme versioningScheme) {
        if (isInCreateMode()) {
            this.innerModel().withVersioningScheme(versioningScheme);
            return this;
        } else {
            this.updateParameters.withVersioningScheme(versioningScheme);
            return this;
        }
    }

    public ApiVersionSetContractImpl withDescription(String description) {
        if (isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        } else {
            this.updateParameters.withDescription(description);
            return this;
        }
    }

    public ApiVersionSetContractImpl withVersionQueryName(String versionQueryName) {
        if (isInCreateMode()) {
            this.innerModel().withVersionQueryName(versionQueryName);
            return this;
        } else {
            this.updateParameters.withVersionQueryName(versionQueryName);
            return this;
        }
    }

    public ApiVersionSetContractImpl withVersionHeaderName(String versionHeaderName) {
        if (isInCreateMode()) {
            this.innerModel().withVersionHeaderName(versionHeaderName);
            return this;
        } else {
            this.updateParameters.withVersionHeaderName(versionHeaderName);
            return this;
        }
    }

    public ApiVersionSetContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
