// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ApiWikisClient;
import com.azure.resourcemanager.apimanagement.fluent.models.WikiContractInner;
import com.azure.resourcemanager.apimanagement.models.ApiWikis;
import com.azure.resourcemanager.apimanagement.models.ApiWikisCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.ApiWikisGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ApiWikisGetResponse;
import com.azure.resourcemanager.apimanagement.models.ApiWikisUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WikiContract;
import com.azure.resourcemanager.apimanagement.models.WikiUpdateContract;

public final class ApiWikisImpl implements ApiWikis {
    private static final ClientLogger LOGGER = new ClientLogger(ApiWikisImpl.class);

    private final ApiWikisClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ApiWikisImpl(ApiWikisClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public ApiWikisGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String apiId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, apiId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String apiId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, apiId);
    }

    public Response<WikiContract> getWithResponse(String resourceGroupName, String serviceName, String apiId,
        Context context) {
        ApiWikisGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, apiId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new WikiContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public WikiContract get(String resourceGroupName, String serviceName, String apiId) {
        WikiContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, apiId);
        if (inner != null) {
            return new WikiContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<WikiContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName, String apiId,
        WikiContractInner parameters, String ifMatch, Context context) {
        ApiWikisCreateOrUpdateResponse inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, apiId, parameters, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new WikiContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public WikiContract createOrUpdate(String resourceGroupName, String serviceName, String apiId,
        WikiContractInner parameters) {
        WikiContractInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, apiId, parameters);
        if (inner != null) {
            return new WikiContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<WikiContract> updateWithResponse(String resourceGroupName, String serviceName, String apiId,
        String ifMatch, WikiUpdateContract parameters, Context context) {
        ApiWikisUpdateResponse inner = this.serviceClient()
            .updateWithResponse(resourceGroupName, serviceName, apiId, ifMatch, parameters, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new WikiContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public WikiContract update(String resourceGroupName, String serviceName, String apiId, String ifMatch,
        WikiUpdateContract parameters) {
        WikiContractInner inner
            = this.serviceClient().update(resourceGroupName, serviceName, apiId, ifMatch, parameters);
        if (inner != null) {
            return new WikiContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String apiId, String ifMatch,
        Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, apiId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String apiId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, apiId, ifMatch);
    }

    private ApiWikisClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
