// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.apimanagement.fluent.AuthorizationAccessPoliciesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationAccessPolicyContractInner;
import com.azure.resourcemanager.apimanagement.models.AuthorizationAccessPoliciesCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationAccessPoliciesGetResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationAccessPolicyCollection;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in AuthorizationAccessPoliciesClient.
 */
public final class AuthorizationAccessPoliciesClientImpl implements AuthorizationAccessPoliciesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final AuthorizationAccessPoliciesService service;

    /**
     * The service client containing this operation class.
     */
    private final ApiManagementClientImpl client;

    /**
     * Initializes an instance of AuthorizationAccessPoliciesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    AuthorizationAccessPoliciesClientImpl(ApiManagementClientImpl client) {
        this.service = RestProxy.create(AuthorizationAccessPoliciesService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ApiManagementClientAuthorizationAccessPolicies to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ApiManagementClientA")
    public interface AuthorizationAccessPoliciesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AuthorizationAccessPolicyCollection>> listByAuthorization(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @PathParam("authorizationProviderId") String authorizationProviderId,
            @PathParam("authorizationId") String authorizationId, @QueryParam("$filter") String filter,
            @QueryParam("$top") Integer top, @QueryParam("$skip") Integer skip,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<AuthorizationAccessPoliciesGetResponse> get(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @PathParam("authorizationProviderId") String authorizationProviderId,
            @PathParam("authorizationId") String authorizationId,
            @PathParam("authorizationAccessPolicyId") String authorizationAccessPolicyId,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<AuthorizationAccessPoliciesCreateOrUpdateResponse> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @PathParam("authorizationProviderId") String authorizationProviderId,
            @PathParam("authorizationId") String authorizationId,
            @PathParam("authorizationAccessPolicyId") String authorizationAccessPolicyId,
            @HeaderParam("If-Match") String ifMatch, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") AuthorizationAccessPolicyContractInner parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serviceName") String serviceName,
            @PathParam("authorizationProviderId") String authorizationProviderId,
            @PathParam("authorizationId") String authorizationId,
            @PathParam("authorizationAccessPolicyId") String authorizationAccessPolicyId,
            @HeaderParam("If-Match") String ifMatch, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AuthorizationAccessPolicyCollection>> listByAuthorizationNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists a collection of authorization access policy defined within a authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| name | filter | ge, le, eq, ne,
     * gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt
     * | substringof, contains, startswith, endswith |&lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Authorization Access Policy list representation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizationAccessPolicyContractInner>> listByAuthorizationSinglePageAsync(
        String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId,
        String filter, Integer top, Integer skip) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByAuthorization(this.client.getEndpoint(), resourceGroupName,
                serviceName, authorizationProviderId, authorizationId, filter, top, skip, this.client.getApiVersion(),
                this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<AuthorizationAccessPolicyContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists a collection of authorization access policy defined within a authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| name | filter | ge, le, eq, ne,
     * gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt
     * | substringof, contains, startswith, endswith |&lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Authorization Access Policy list representation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizationAccessPolicyContractInner>> listByAuthorizationSinglePageAsync(
        String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId,
        String filter, Integer top, Integer skip, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByAuthorization(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId,
                authorizationId, filter, top, skip, this.client.getApiVersion(), this.client.getSubscriptionId(),
                accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists a collection of authorization access policy defined within a authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| name | filter | ge, le, eq, ne,
     * gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt
     * | substringof, contains, startswith, endswith |&lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Authorization Access Policy list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<AuthorizationAccessPolicyContractInner> listByAuthorizationAsync(String resourceGroupName,
        String serviceName, String authorizationProviderId, String authorizationId, String filter, Integer top,
        Integer skip) {
        return new PagedFlux<>(() -> listByAuthorizationSinglePageAsync(resourceGroupName, serviceName,
            authorizationProviderId, authorizationId, filter, top, skip),
            nextLink -> listByAuthorizationNextSinglePageAsync(nextLink));
    }

    /**
     * Lists a collection of authorization access policy defined within a authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Authorization Access Policy list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<AuthorizationAccessPolicyContractInner> listByAuthorizationAsync(String resourceGroupName,
        String serviceName, String authorizationProviderId, String authorizationId) {
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        return new PagedFlux<>(() -> listByAuthorizationSinglePageAsync(resourceGroupName, serviceName,
            authorizationProviderId, authorizationId, filter, top, skip),
            nextLink -> listByAuthorizationNextSinglePageAsync(nextLink));
    }

    /**
     * Lists a collection of authorization access policy defined within a authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| name | filter | ge, le, eq, ne,
     * gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt
     * | substringof, contains, startswith, endswith |&lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Authorization Access Policy list representation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<AuthorizationAccessPolicyContractInner> listByAuthorizationAsync(String resourceGroupName,
        String serviceName, String authorizationProviderId, String authorizationId, String filter, Integer top,
        Integer skip, Context context) {
        return new PagedFlux<>(
            () -> listByAuthorizationSinglePageAsync(resourceGroupName, serviceName, authorizationProviderId,
                authorizationId, filter, top, skip, context),
            nextLink -> listByAuthorizationNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists a collection of authorization access policy defined within a authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Authorization Access Policy list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AuthorizationAccessPolicyContractInner> listByAuthorization(String resourceGroupName,
        String serviceName, String authorizationProviderId, String authorizationId) {
        final String filter = null;
        final Integer top = null;
        final Integer skip = null;
        return new PagedIterable<>(listByAuthorizationAsync(resourceGroupName, serviceName, authorizationProviderId,
            authorizationId, filter, top, skip));
    }

    /**
     * Lists a collection of authorization access policy defined within a authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param filter | Field | Usage | Supported operators | Supported functions
     * |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| name | filter | ge, le, eq, ne,
     * gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt
     * | substringof, contains, startswith, endswith |&lt;/br&gt;.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Authorization Access Policy list representation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AuthorizationAccessPolicyContractInner> listByAuthorization(String resourceGroupName,
        String serviceName, String authorizationProviderId, String authorizationId, String filter, Integer top,
        Integer skip, Context context) {
        return new PagedIterable<>(listByAuthorizationAsync(resourceGroupName, serviceName, authorizationProviderId,
            authorizationId, filter, top, skip, context));
    }

    /**
     * Gets the details of the authorization access policy specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the authorization access policy specified by its identifier on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AuthorizationAccessPoliciesGetResponse> getWithResponseAsync(String resourceGroupName,
        String serviceName, String authorizationProviderId, String authorizationId,
        String authorizationAccessPolicyId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (authorizationAccessPolicyId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationAccessPolicyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), resourceGroupName, serviceName,
                authorizationProviderId, authorizationId, authorizationAccessPolicyId, this.client.getApiVersion(),
                this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the details of the authorization access policy specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the authorization access policy specified by its identifier on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AuthorizationAccessPoliciesGetResponse> getWithResponseAsync(String resourceGroupName,
        String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (authorizationAccessPolicyId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationAccessPolicyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId,
            authorizationId, authorizationAccessPolicyId, this.client.getApiVersion(), this.client.getSubscriptionId(),
            accept, context);
    }

    /**
     * Gets the details of the authorization access policy specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the authorization access policy specified by its identifier on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AuthorizationAccessPolicyContractInner> getAsync(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId) {
        return getWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
            authorizationAccessPolicyId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the details of the authorization access policy specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the authorization access policy specified by its identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AuthorizationAccessPoliciesGetResponse getWithResponse(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, Context context) {
        return getWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
            authorizationAccessPolicyId, context).block();
    }

    /**
     * Gets the details of the authorization access policy specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the authorization access policy specified by its identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AuthorizationAccessPolicyContractInner get(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId) {
        return getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
            authorizationAccessPolicyId, Context.NONE).getValue();
    }

    /**
     * Creates or updates Authorization Access Policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param parameters Create parameters.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization access policy contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AuthorizationAccessPoliciesCreateOrUpdateResponse> createOrUpdateWithResponseAsync(
        String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId,
        String authorizationAccessPolicyId, AuthorizationAccessPolicyContractInner parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (authorizationAccessPolicyId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationAccessPolicyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName,
                authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch,
                this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates Authorization Access Policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param parameters Create parameters.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization access policy contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AuthorizationAccessPoliciesCreateOrUpdateResponse> createOrUpdateWithResponseAsync(
        String resourceGroupName, String serviceName, String authorizationProviderId, String authorizationId,
        String authorizationAccessPolicyId, AuthorizationAccessPolicyContractInner parameters, String ifMatch,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (authorizationAccessPolicyId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationAccessPolicyId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serviceName,
            authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch, this.client.getApiVersion(),
            this.client.getSubscriptionId(), parameters, accept, context);
    }

    /**
     * Creates or updates Authorization Access Policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param parameters Create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization access policy contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AuthorizationAccessPolicyContractInner> createOrUpdateAsync(String resourceGroupName,
        String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId,
        AuthorizationAccessPolicyContractInner parameters) {
        final String ifMatch = null;
        return createOrUpdateWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
            authorizationAccessPolicyId, parameters, ifMatch).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates Authorization Access Policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param parameters Create parameters.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization access policy contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AuthorizationAccessPoliciesCreateOrUpdateResponse createOrUpdateWithResponse(String resourceGroupName,
        String serviceName, String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId,
        AuthorizationAccessPolicyContractInner parameters, String ifMatch, Context context) {
        return createOrUpdateWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
            authorizationAccessPolicyId, parameters, ifMatch, context).block();
    }

    /**
     * Creates or updates Authorization Access Policy.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param parameters Create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization access policy contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AuthorizationAccessPolicyContractInner createOrUpdate(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId,
        AuthorizationAccessPolicyContractInner parameters) {
        final String ifMatch = null;
        return createOrUpdateWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
            authorizationAccessPolicyId, parameters, ifMatch, Context.NONE).getValue();
    }

    /**
     * Deletes specific access policy from the Authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (authorizationAccessPolicyId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationAccessPolicyId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error(new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), resourceGroupName, serviceName,
                authorizationProviderId, authorizationId, authorizationAccessPolicyId, ifMatch,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes specific access policy from the Authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, String ifMatch,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (authorizationProviderId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationProviderId is required and cannot be null."));
        }
        if (authorizationId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter authorizationId is required and cannot be null."));
        }
        if (authorizationAccessPolicyId == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter authorizationAccessPolicyId is required and cannot be null."));
        }
        if (ifMatch == null) {
            return Mono.error(new IllegalArgumentException("Parameter ifMatch is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), resourceGroupName, serviceName, authorizationProviderId,
            authorizationId, authorizationAccessPolicyId, ifMatch, this.client.getApiVersion(),
            this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Deletes specific access policy from the Authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String authorizationProviderId,
        String authorizationId, String authorizationAccessPolicyId, String ifMatch) {
        return deleteWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
            authorizationAccessPolicyId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes specific access policy from the Authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, String authorizationAccessPolicyId, String ifMatch,
        Context context) {
        return deleteWithResponseAsync(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
            authorizationAccessPolicyId, ifMatch, context).block();
    }

    /**
     * Deletes specific access policy from the Authorization.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param authorizationProviderId Identifier of the authorization provider.
     * @param authorizationId Identifier of the authorization.
     * @param authorizationAccessPolicyId Identifier of the authorization access policy.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String authorizationProviderId,
        String authorizationId, String authorizationAccessPolicyId, String ifMatch) {
        deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
            authorizationAccessPolicyId, ifMatch, Context.NONE);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Authorization Access Policy list representation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizationAccessPolicyContractInner>>
        listByAuthorizationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByAuthorizationNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<AuthorizationAccessPolicyContractInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged Authorization Access Policy list representation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizationAccessPolicyContractInner>>
        listByAuthorizationNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByAuthorizationNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
