// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationAccessPolicyContractInner;
import com.azure.resourcemanager.apimanagement.models.AuthorizationAccessPolicyContract;
import java.util.Collections;
import java.util.List;

public final class AuthorizationAccessPolicyContractImpl implements AuthorizationAccessPolicyContract,
    AuthorizationAccessPolicyContract.Definition, AuthorizationAccessPolicyContract.Update {
    private AuthorizationAccessPolicyContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public List<String> appIds() {
        List<String> inner = this.innerModel().appIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String tenantId() {
        return this.innerModel().tenantId();
    }

    public String objectId() {
        return this.innerModel().objectId();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public AuthorizationAccessPolicyContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String authorizationProviderId;

    private String authorizationId;

    private String authorizationAccessPolicyId;

    private String createIfMatch;

    private String updateIfMatch;

    public AuthorizationAccessPolicyContractImpl withExistingAuthorization(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.authorizationProviderId = authorizationProviderId;
        this.authorizationId = authorizationId;
        return this;
    }

    public AuthorizationAccessPolicyContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizationAccessPolicies()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
                authorizationAccessPolicyId, this.innerModel(), createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public AuthorizationAccessPolicyContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizationAccessPolicies()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
                authorizationAccessPolicyId, this.innerModel(), createIfMatch, context)
            .getValue();
        return this;
    }

    AuthorizationAccessPolicyContractImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new AuthorizationAccessPolicyContractInner();
        this.serviceManager = serviceManager;
        this.authorizationAccessPolicyId = name;
        this.createIfMatch = null;
    }

    public AuthorizationAccessPolicyContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public AuthorizationAccessPolicyContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizationAccessPolicies()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
                authorizationAccessPolicyId, this.innerModel(), updateIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public AuthorizationAccessPolicyContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizationAccessPolicies()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
                authorizationAccessPolicyId, this.innerModel(), updateIfMatch, context)
            .getValue();
        return this;
    }

    AuthorizationAccessPolicyContractImpl(AuthorizationAccessPolicyContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.authorizationProviderId
            = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authorizationProviders");
        this.authorizationId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authorizations");
        this.authorizationAccessPolicyId
            = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "accessPolicies");
    }

    public AuthorizationAccessPolicyContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizationAccessPolicies()
            .getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
                authorizationAccessPolicyId, Context.NONE)
            .getValue();
        return this;
    }

    public AuthorizationAccessPolicyContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizationAccessPolicies()
            .getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
                authorizationAccessPolicyId, context)
            .getValue();
        return this;
    }

    public AuthorizationAccessPolicyContractImpl withAppIds(List<String> appIds) {
        this.innerModel().withAppIds(appIds);
        return this;
    }

    public AuthorizationAccessPolicyContractImpl withTenantId(String tenantId) {
        this.innerModel().withTenantId(tenantId);
        return this;
    }

    public AuthorizationAccessPolicyContractImpl withObjectId(String objectId) {
        this.innerModel().withObjectId(objectId);
        return this;
    }

    public AuthorizationAccessPolicyContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
