// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationContractInner;
import com.azure.resourcemanager.apimanagement.models.AuthorizationConfirmConsentCodeRequestContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationError;
import com.azure.resourcemanager.apimanagement.models.AuthorizationType;
import com.azure.resourcemanager.apimanagement.models.AuthorizationsConfirmConsentCodeResponse;
import com.azure.resourcemanager.apimanagement.models.OAuth2GrantType;
import java.util.Collections;
import java.util.Map;

public final class AuthorizationContractImpl
    implements AuthorizationContract, AuthorizationContract.Definition, AuthorizationContract.Update {
    private AuthorizationContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public AuthorizationType authorizationType() {
        return this.innerModel().authorizationType();
    }

    public OAuth2GrantType oAuth2GrantType() {
        return this.innerModel().oAuth2GrantType();
    }

    public Map<String, String> parameters() {
        Map<String, String> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public AuthorizationError error() {
        return this.innerModel().error();
    }

    public String status() {
        return this.innerModel().status();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public AuthorizationContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String authorizationProviderId;

    private String authorizationId;

    private String createIfMatch;

    private String updateIfMatch;

    public AuthorizationContractImpl withExistingAuthorizationProvider(String resourceGroupName, String serviceName,
        String authorizationProviderId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.authorizationProviderId = authorizationProviderId;
        return this;
    }

    public AuthorizationContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizations()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
                this.innerModel(), createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public AuthorizationContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizations()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
                this.innerModel(), createIfMatch, context)
            .getValue();
        return this;
    }

    AuthorizationContractImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new AuthorizationContractInner();
        this.serviceManager = serviceManager;
        this.authorizationId = name;
        this.createIfMatch = null;
    }

    public AuthorizationContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public AuthorizationContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizations()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
                this.innerModel(), updateIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public AuthorizationContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizations()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
                this.innerModel(), updateIfMatch, context)
            .getValue();
        return this;
    }

    AuthorizationContractImpl(AuthorizationContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.authorizationProviderId
            = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authorizationProviders");
        this.authorizationId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authorizations");
    }

    public AuthorizationContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizations()
            .getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, Context.NONE)
            .getValue();
        return this;
    }

    public AuthorizationContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizations()
            .getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, context)
            .getValue();
        return this;
    }

    public AuthorizationsConfirmConsentCodeResponse
        confirmConsentCodeWithResponse(AuthorizationConfirmConsentCodeRequestContract parameters, Context context) {
        return serviceManager.authorizations()
            .confirmConsentCodeWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
                parameters, context);
    }

    public void confirmConsentCode(AuthorizationConfirmConsentCodeRequestContract parameters) {
        serviceManager.authorizations()
            .confirmConsentCode(resourceGroupName, serviceName, authorizationProviderId, authorizationId, parameters);
    }

    public AuthorizationContractImpl withAuthorizationType(AuthorizationType authorizationType) {
        this.innerModel().withAuthorizationType(authorizationType);
        return this;
    }

    public AuthorizationContractImpl withOAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
        this.innerModel().withOAuth2GrantType(oAuth2GrantType);
        return this;
    }

    public AuthorizationContractImpl withParameters(Map<String, String> parameters) {
        this.innerModel().withParameters(parameters);
        return this;
    }

    public AuthorizationContractImpl withError(AuthorizationError error) {
        this.innerModel().withError(error);
        return this;
    }

    public AuthorizationContractImpl withStatus(String status) {
        this.innerModel().withStatus(status);
        return this;
    }

    public AuthorizationContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
