// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.AuthorizationLoginLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationLoginResponseContractInner;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginLinks;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginLinksPostResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginRequestContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationLoginResponseContract;

public final class AuthorizationLoginLinksImpl implements AuthorizationLoginLinks {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationLoginLinksImpl.class);

    private final AuthorizationLoginLinksClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public AuthorizationLoginLinksImpl(AuthorizationLoginLinksClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<AuthorizationLoginResponseContract> postWithResponse(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, AuthorizationLoginRequestContract parameters,
        Context context) {
        AuthorizationLoginLinksPostResponse inner = this.serviceClient()
            .postWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, parameters,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new AuthorizationLoginResponseContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public AuthorizationLoginResponseContract post(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, AuthorizationLoginRequestContract parameters) {
        AuthorizationLoginResponseContractInner inner = this.serviceClient()
            .post(resourceGroupName, serviceName, authorizationProviderId, authorizationId, parameters);
        if (inner != null) {
            return new AuthorizationLoginResponseContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private AuthorizationLoginLinksClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
