// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationServerContractInner;
import com.azure.resourcemanager.apimanagement.models.AuthorizationMethod;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServerContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServerSecretsContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServerUpdateContract;
import com.azure.resourcemanager.apimanagement.models.BearerTokenSendingMethod;
import com.azure.resourcemanager.apimanagement.models.ClientAuthenticationMethod;
import com.azure.resourcemanager.apimanagement.models.GrantType;
import com.azure.resourcemanager.apimanagement.models.TokenBodyParameterContract;
import java.util.Collections;
import java.util.List;

public final class AuthorizationServerContractImpl
    implements AuthorizationServerContract, AuthorizationServerContract.Definition, AuthorizationServerContract.Update {
    private AuthorizationServerContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String displayName() {
        return this.innerModel().displayName();
    }

    public Boolean useInTestConsole() {
        return this.innerModel().useInTestConsole();
    }

    public Boolean useInApiDocumentation() {
        return this.innerModel().useInApiDocumentation();
    }

    public String clientRegistrationEndpoint() {
        return this.innerModel().clientRegistrationEndpoint();
    }

    public String authorizationEndpoint() {
        return this.innerModel().authorizationEndpoint();
    }

    public List<GrantType> grantTypes() {
        List<GrantType> inner = this.innerModel().grantTypes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String clientId() {
        return this.innerModel().clientId();
    }

    public String clientSecret() {
        return this.innerModel().clientSecret();
    }

    public String description() {
        return this.innerModel().description();
    }

    public List<AuthorizationMethod> authorizationMethods() {
        List<AuthorizationMethod> inner = this.innerModel().authorizationMethods();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<ClientAuthenticationMethod> clientAuthenticationMethod() {
        List<ClientAuthenticationMethod> inner = this.innerModel().clientAuthenticationMethod();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<TokenBodyParameterContract> tokenBodyParameters() {
        List<TokenBodyParameterContract> inner = this.innerModel().tokenBodyParameters();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String tokenEndpoint() {
        return this.innerModel().tokenEndpoint();
    }

    public Boolean supportState() {
        return this.innerModel().supportState();
    }

    public String defaultScope() {
        return this.innerModel().defaultScope();
    }

    public List<BearerTokenSendingMethod> bearerTokenSendingMethods() {
        List<BearerTokenSendingMethod> inner = this.innerModel().bearerTokenSendingMethods();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String resourceOwnerUsername() {
        return this.innerModel().resourceOwnerUsername();
    }

    public String resourceOwnerPassword() {
        return this.innerModel().resourceOwnerPassword();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public AuthorizationServerContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String authsid;

    private String createIfMatch;

    private String updateIfMatch;

    private AuthorizationServerUpdateContract updateParameters;

    public AuthorizationServerContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public AuthorizationServerContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizationServers()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, authsid, this.innerModel(), createIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public AuthorizationServerContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizationServers()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, authsid, this.innerModel(), createIfMatch,
                context)
            .getValue();
        return this;
    }

    AuthorizationServerContractImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new AuthorizationServerContractInner();
        this.serviceManager = serviceManager;
        this.authsid = name;
        this.createIfMatch = null;
    }

    public AuthorizationServerContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new AuthorizationServerUpdateContract();
        return this;
    }

    public AuthorizationServerContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizationServers()
            .updateWithResponse(resourceGroupName, serviceName, authsid, updateIfMatch, updateParameters, Context.NONE)
            .getValue();
        return this;
    }

    public AuthorizationServerContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizationServers()
            .updateWithResponse(resourceGroupName, serviceName, authsid, updateIfMatch, updateParameters, context)
            .getValue();
        return this;
    }

    AuthorizationServerContractImpl(AuthorizationServerContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.authsid = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authorizationServers");
    }

    public AuthorizationServerContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizationServers()
            .getWithResponse(resourceGroupName, serviceName, authsid, Context.NONE)
            .getValue();
        return this;
    }

    public AuthorizationServerContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAuthorizationServers()
            .getWithResponse(resourceGroupName, serviceName, authsid, context)
            .getValue();
        return this;
    }

    public Response<AuthorizationServerSecretsContract> listSecretsWithResponse(Context context) {
        return serviceManager.authorizationServers()
            .listSecretsWithResponse(resourceGroupName, serviceName, authsid, context);
    }

    public AuthorizationServerSecretsContract listSecrets() {
        return serviceManager.authorizationServers().listSecrets(resourceGroupName, serviceName, authsid);
    }

    public AuthorizationServerContractImpl withDisplayName(String displayName) {
        if (isInCreateMode()) {
            this.innerModel().withDisplayName(displayName);
            return this;
        } else {
            this.updateParameters.withDisplayName(displayName);
            return this;
        }
    }

    public AuthorizationServerContractImpl withUseInTestConsole(Boolean useInTestConsole) {
        if (isInCreateMode()) {
            this.innerModel().withUseInTestConsole(useInTestConsole);
            return this;
        } else {
            this.updateParameters.withUseInTestConsole(useInTestConsole);
            return this;
        }
    }

    public AuthorizationServerContractImpl withUseInApiDocumentation(Boolean useInApiDocumentation) {
        if (isInCreateMode()) {
            this.innerModel().withUseInApiDocumentation(useInApiDocumentation);
            return this;
        } else {
            this.updateParameters.withUseInApiDocumentation(useInApiDocumentation);
            return this;
        }
    }

    public AuthorizationServerContractImpl withClientRegistrationEndpoint(String clientRegistrationEndpoint) {
        if (isInCreateMode()) {
            this.innerModel().withClientRegistrationEndpoint(clientRegistrationEndpoint);
            return this;
        } else {
            this.updateParameters.withClientRegistrationEndpoint(clientRegistrationEndpoint);
            return this;
        }
    }

    public AuthorizationServerContractImpl withAuthorizationEndpoint(String authorizationEndpoint) {
        if (isInCreateMode()) {
            this.innerModel().withAuthorizationEndpoint(authorizationEndpoint);
            return this;
        } else {
            this.updateParameters.withAuthorizationEndpoint(authorizationEndpoint);
            return this;
        }
    }

    public AuthorizationServerContractImpl withGrantTypes(List<GrantType> grantTypes) {
        if (isInCreateMode()) {
            this.innerModel().withGrantTypes(grantTypes);
            return this;
        } else {
            this.updateParameters.withGrantTypes(grantTypes);
            return this;
        }
    }

    public AuthorizationServerContractImpl withClientId(String clientId) {
        if (isInCreateMode()) {
            this.innerModel().withClientId(clientId);
            return this;
        } else {
            this.updateParameters.withClientId(clientId);
            return this;
        }
    }

    public AuthorizationServerContractImpl withClientSecret(String clientSecret) {
        if (isInCreateMode()) {
            this.innerModel().withClientSecret(clientSecret);
            return this;
        } else {
            this.updateParameters.withClientSecret(clientSecret);
            return this;
        }
    }

    public AuthorizationServerContractImpl withDescription(String description) {
        if (isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        } else {
            this.updateParameters.withDescription(description);
            return this;
        }
    }

    public AuthorizationServerContractImpl withAuthorizationMethods(List<AuthorizationMethod> authorizationMethods) {
        if (isInCreateMode()) {
            this.innerModel().withAuthorizationMethods(authorizationMethods);
            return this;
        } else {
            this.updateParameters.withAuthorizationMethods(authorizationMethods);
            return this;
        }
    }

    public AuthorizationServerContractImpl
        withClientAuthenticationMethod(List<ClientAuthenticationMethod> clientAuthenticationMethod) {
        if (isInCreateMode()) {
            this.innerModel().withClientAuthenticationMethod(clientAuthenticationMethod);
            return this;
        } else {
            this.updateParameters.withClientAuthenticationMethod(clientAuthenticationMethod);
            return this;
        }
    }

    public AuthorizationServerContractImpl
        withTokenBodyParameters(List<TokenBodyParameterContract> tokenBodyParameters) {
        if (isInCreateMode()) {
            this.innerModel().withTokenBodyParameters(tokenBodyParameters);
            return this;
        } else {
            this.updateParameters.withTokenBodyParameters(tokenBodyParameters);
            return this;
        }
    }

    public AuthorizationServerContractImpl withTokenEndpoint(String tokenEndpoint) {
        if (isInCreateMode()) {
            this.innerModel().withTokenEndpoint(tokenEndpoint);
            return this;
        } else {
            this.updateParameters.withTokenEndpoint(tokenEndpoint);
            return this;
        }
    }

    public AuthorizationServerContractImpl withSupportState(Boolean supportState) {
        if (isInCreateMode()) {
            this.innerModel().withSupportState(supportState);
            return this;
        } else {
            this.updateParameters.withSupportState(supportState);
            return this;
        }
    }

    public AuthorizationServerContractImpl withDefaultScope(String defaultScope) {
        if (isInCreateMode()) {
            this.innerModel().withDefaultScope(defaultScope);
            return this;
        } else {
            this.updateParameters.withDefaultScope(defaultScope);
            return this;
        }
    }

    public AuthorizationServerContractImpl
        withBearerTokenSendingMethods(List<BearerTokenSendingMethod> bearerTokenSendingMethods) {
        if (isInCreateMode()) {
            this.innerModel().withBearerTokenSendingMethods(bearerTokenSendingMethods);
            return this;
        } else {
            this.updateParameters.withBearerTokenSendingMethods(bearerTokenSendingMethods);
            return this;
        }
    }

    public AuthorizationServerContractImpl withResourceOwnerUsername(String resourceOwnerUsername) {
        if (isInCreateMode()) {
            this.innerModel().withResourceOwnerUsername(resourceOwnerUsername);
            return this;
        } else {
            this.updateParameters.withResourceOwnerUsername(resourceOwnerUsername);
            return this;
        }
    }

    public AuthorizationServerContractImpl withResourceOwnerPassword(String resourceOwnerPassword) {
        if (isInCreateMode()) {
            this.innerModel().withResourceOwnerPassword(resourceOwnerPassword);
            return this;
        } else {
            this.updateParameters.withResourceOwnerPassword(resourceOwnerPassword);
            return this;
        }
    }

    public AuthorizationServerContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
