// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.AuthorizationServersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationServerContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationServerSecretsContractInner;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServerContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServerSecretsContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServers;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServersGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServersGetResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationServersListSecretsResponse;

public final class AuthorizationServersImpl implements AuthorizationServers {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationServersImpl.class);

    private final AuthorizationServersClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public AuthorizationServersImpl(AuthorizationServersClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<AuthorizationServerContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<AuthorizationServerContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new AuthorizationServerContractImpl(inner1, this.manager()));
    }

    public PagedIterable<AuthorizationServerContract> listByService(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, Context context) {
        PagedIterable<AuthorizationServerContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new AuthorizationServerContractImpl(inner1, this.manager()));
    }

    public AuthorizationServersGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName,
        String serviceName, String authsid, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, authsid, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String authsid) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, authsid);
    }

    public Response<AuthorizationServerContract> getWithResponse(String resourceGroupName, String serviceName,
        String authsid, Context context) {
        AuthorizationServersGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, authsid, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new AuthorizationServerContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public AuthorizationServerContract get(String resourceGroupName, String serviceName, String authsid) {
        AuthorizationServerContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, authsid);
        if (inner != null) {
            return new AuthorizationServerContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String authsid,
        String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, authsid, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String authsid, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, authsid, ifMatch);
    }

    public Response<AuthorizationServerSecretsContract> listSecretsWithResponse(String resourceGroupName,
        String serviceName, String authsid, Context context) {
        AuthorizationServersListSecretsResponse inner
            = this.serviceClient().listSecretsWithResponse(resourceGroupName, serviceName, authsid, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new AuthorizationServerSecretsContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public AuthorizationServerSecretsContract listSecrets(String resourceGroupName, String serviceName,
        String authsid) {
        AuthorizationServerSecretsContractInner inner
            = this.serviceClient().listSecrets(resourceGroupName, serviceName, authsid);
        if (inner != null) {
            return new AuthorizationServerSecretsContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public AuthorizationServerContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authsid = ResourceManagerUtils.getValueFromIdByName(id, "authorizationServers");
        if (authsid == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationServers'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, authsid, Context.NONE).getValue();
    }

    public Response<AuthorizationServerContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authsid = ResourceManagerUtils.getValueFromIdByName(id, "authorizationServers");
        if (authsid == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationServers'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, authsid, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authsid = ResourceManagerUtils.getValueFromIdByName(id, "authorizationServers");
        if (authsid == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationServers'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, authsid, localIfMatch, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authsid = ResourceManagerUtils.getValueFromIdByName(id, "authorizationServers");
        if (authsid == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'authorizationServers'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, authsid, ifMatch, context);
    }

    private AuthorizationServersClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public AuthorizationServerContractImpl define(String name) {
        return new AuthorizationServerContractImpl(name, this.manager());
    }
}
