// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.AuthorizationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationContractInner;
import com.azure.resourcemanager.apimanagement.models.AuthorizationConfirmConsentCodeRequestContract;
import com.azure.resourcemanager.apimanagement.models.AuthorizationContract;
import com.azure.resourcemanager.apimanagement.models.Authorizations;
import com.azure.resourcemanager.apimanagement.models.AuthorizationsConfirmConsentCodeResponse;
import com.azure.resourcemanager.apimanagement.models.AuthorizationsGetResponse;

public final class AuthorizationsImpl implements Authorizations {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationsImpl.class);

    private final AuthorizationsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public AuthorizationsImpl(AuthorizationsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<AuthorizationContract> listByAuthorizationProvider(String resourceGroupName,
        String serviceName, String authorizationProviderId) {
        PagedIterable<AuthorizationContractInner> inner
            = this.serviceClient().listByAuthorizationProvider(resourceGroupName, serviceName, authorizationProviderId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthorizationContractImpl(inner1, this.manager()));
    }

    public PagedIterable<AuthorizationContract> listByAuthorizationProvider(String resourceGroupName,
        String serviceName, String authorizationProviderId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<AuthorizationContractInner> inner = this.serviceClient()
            .listByAuthorizationProvider(resourceGroupName, serviceName, authorizationProviderId, filter, top, skip,
                context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthorizationContractImpl(inner1, this.manager()));
    }

    public Response<AuthorizationContract> getWithResponse(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, Context context) {
        AuthorizationsGetResponse inner = this.serviceClient()
            .getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new AuthorizationContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public AuthorizationContract get(String resourceGroupName, String serviceName, String authorizationProviderId,
        String authorizationId) {
        AuthorizationContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, authorizationProviderId, authorizationId);
        if (inner != null) {
            return new AuthorizationContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName,
        String authorizationProviderId, String authorizationId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, ifMatch,
                context);
    }

    public void delete(String resourceGroupName, String serviceName, String authorizationProviderId,
        String authorizationId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, authorizationProviderId, authorizationId, ifMatch);
    }

    public AuthorizationsConfirmConsentCodeResponse confirmConsentCodeWithResponse(String resourceGroupName,
        String serviceName, String authorizationProviderId, String authorizationId,
        AuthorizationConfirmConsentCodeRequestContract parameters, Context context) {
        return this.serviceClient()
            .confirmConsentCodeWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
                parameters, context);
    }

    public void confirmConsentCode(String resourceGroupName, String serviceName, String authorizationProviderId,
        String authorizationId, AuthorizationConfirmConsentCodeRequestContract parameters) {
        this.serviceClient()
            .confirmConsentCode(resourceGroupName, serviceName, authorizationProviderId, authorizationId, parameters);
    }

    public AuthorizationContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(String
                .format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String authorizationId = ResourceManagerUtils.getValueFromIdByName(id, "authorizations");
        if (authorizationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'authorizations'.", id)));
        }
        return this
            .getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, Context.NONE)
            .getValue();
    }

    public Response<AuthorizationContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(String
                .format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String authorizationId = ResourceManagerUtils.getValueFromIdByName(id, "authorizations");
        if (authorizationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'authorizations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(String
                .format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String authorizationId = ResourceManagerUtils.getValueFromIdByName(id, "authorizations");
        if (authorizationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'authorizations'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId, localIfMatch,
            Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String authorizationProviderId = ResourceManagerUtils.getValueFromIdByName(id, "authorizationProviders");
        if (authorizationProviderId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(String
                .format("The resource ID '%s' is not valid. Missing path segment 'authorizationProviders'.", id)));
        }
        String authorizationId = ResourceManagerUtils.getValueFromIdByName(id, "authorizations");
        if (authorizationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'authorizations'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, authorizationProviderId, authorizationId,
            ifMatch, context);
    }

    private AuthorizationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public AuthorizationContractImpl define(String name) {
        return new AuthorizationContractImpl(name, this.manager());
    }
}
