// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.BackendContractInner;
import com.azure.resourcemanager.apimanagement.models.BackendBaseParametersPool;
import com.azure.resourcemanager.apimanagement.models.BackendCircuitBreaker;
import com.azure.resourcemanager.apimanagement.models.BackendContract;
import com.azure.resourcemanager.apimanagement.models.BackendCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.BackendProperties;
import com.azure.resourcemanager.apimanagement.models.BackendProtocol;
import com.azure.resourcemanager.apimanagement.models.BackendProxyContract;
import com.azure.resourcemanager.apimanagement.models.BackendReconnectContract;
import com.azure.resourcemanager.apimanagement.models.BackendTlsProperties;
import com.azure.resourcemanager.apimanagement.models.BackendType;
import com.azure.resourcemanager.apimanagement.models.BackendUpdateParameters;

public final class BackendContractImpl implements BackendContract, BackendContract.Definition, BackendContract.Update {
    private BackendContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String url() {
        return this.innerModel().url();
    }

    public BackendProtocol protocol() {
        return this.innerModel().protocol();
    }

    public String title() {
        return this.innerModel().title();
    }

    public String description() {
        return this.innerModel().description();
    }

    public String resourceId() {
        return this.innerModel().resourceId();
    }

    public BackendProperties properties() {
        return this.innerModel().properties();
    }

    public BackendCredentialsContract credentials() {
        return this.innerModel().credentials();
    }

    public BackendProxyContract proxy() {
        return this.innerModel().proxy();
    }

    public BackendTlsProperties tls() {
        return this.innerModel().tls();
    }

    public BackendCircuitBreaker circuitBreaker() {
        return this.innerModel().circuitBreaker();
    }

    public BackendBaseParametersPool pool() {
        return this.innerModel().pool();
    }

    public BackendType typePropertiesType() {
        return this.innerModel().typePropertiesType();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public BackendContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String backendId;

    private String createIfMatch;

    private String updateIfMatch;

    private BackendUpdateParameters updateParameters;

    public BackendContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public BackendContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getBackends()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, backendId, this.innerModel(), createIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public BackendContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getBackends()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, backendId, this.innerModel(), createIfMatch,
                context)
            .getValue();
        return this;
    }

    BackendContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new BackendContractInner();
        this.serviceManager = serviceManager;
        this.backendId = name;
        this.createIfMatch = null;
    }

    public BackendContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new BackendUpdateParameters();
        return this;
    }

    public BackendContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getBackends()
            .updateWithResponse(resourceGroupName, serviceName, backendId, updateIfMatch, updateParameters,
                Context.NONE)
            .getValue();
        return this;
    }

    public BackendContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getBackends()
            .updateWithResponse(resourceGroupName, serviceName, backendId, updateIfMatch, updateParameters, context)
            .getValue();
        return this;
    }

    BackendContractImpl(BackendContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.backendId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backends");
    }

    public BackendContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getBackends()
            .getWithResponse(resourceGroupName, serviceName, backendId, Context.NONE)
            .getValue();
        return this;
    }

    public BackendContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getBackends()
            .getWithResponse(resourceGroupName, serviceName, backendId, context)
            .getValue();
        return this;
    }

    public Response<Void> reconnectWithResponse(BackendReconnectContract parameters, Context context) {
        return serviceManager.backends()
            .reconnectWithResponse(resourceGroupName, serviceName, backendId, parameters, context);
    }

    public void reconnect() {
        serviceManager.backends().reconnect(resourceGroupName, serviceName, backendId);
    }

    public BackendContractImpl withUrl(String url) {
        if (isInCreateMode()) {
            this.innerModel().withUrl(url);
            return this;
        } else {
            this.updateParameters.withUrl(url);
            return this;
        }
    }

    public BackendContractImpl withProtocol(BackendProtocol protocol) {
        if (isInCreateMode()) {
            this.innerModel().withProtocol(protocol);
            return this;
        } else {
            this.updateParameters.withProtocol(protocol);
            return this;
        }
    }

    public BackendContractImpl withTitle(String title) {
        if (isInCreateMode()) {
            this.innerModel().withTitle(title);
            return this;
        } else {
            this.updateParameters.withTitle(title);
            return this;
        }
    }

    public BackendContractImpl withDescription(String description) {
        if (isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        } else {
            this.updateParameters.withDescription(description);
            return this;
        }
    }

    public BackendContractImpl withResourceId(String resourceId) {
        if (isInCreateMode()) {
            this.innerModel().withResourceId(resourceId);
            return this;
        } else {
            this.updateParameters.withResourceId(resourceId);
            return this;
        }
    }

    public BackendContractImpl withProperties(BackendProperties properties) {
        if (isInCreateMode()) {
            this.innerModel().withProperties(properties);
            return this;
        } else {
            this.updateParameters.withProperties(properties);
            return this;
        }
    }

    public BackendContractImpl withCredentials(BackendCredentialsContract credentials) {
        if (isInCreateMode()) {
            this.innerModel().withCredentials(credentials);
            return this;
        } else {
            this.updateParameters.withCredentials(credentials);
            return this;
        }
    }

    public BackendContractImpl withProxy(BackendProxyContract proxy) {
        if (isInCreateMode()) {
            this.innerModel().withProxy(proxy);
            return this;
        } else {
            this.updateParameters.withProxy(proxy);
            return this;
        }
    }

    public BackendContractImpl withTls(BackendTlsProperties tls) {
        if (isInCreateMode()) {
            this.innerModel().withTls(tls);
            return this;
        } else {
            this.updateParameters.withTls(tls);
            return this;
        }
    }

    public BackendContractImpl withCircuitBreaker(BackendCircuitBreaker circuitBreaker) {
        if (isInCreateMode()) {
            this.innerModel().withCircuitBreaker(circuitBreaker);
            return this;
        } else {
            this.updateParameters.withCircuitBreaker(circuitBreaker);
            return this;
        }
    }

    public BackendContractImpl withPool(BackendBaseParametersPool pool) {
        if (isInCreateMode()) {
            this.innerModel().withPool(pool);
            return this;
        } else {
            this.updateParameters.withPool(pool);
            return this;
        }
    }

    public BackendContractImpl withTypePropertiesType(BackendType typePropertiesType) {
        this.innerModel().withTypePropertiesType(typePropertiesType);
        return this;
    }

    public BackendContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    public BackendContractImpl withType(BackendType type) {
        this.updateParameters.withType(type);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
