// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.CacheContractInner;
import com.azure.resourcemanager.apimanagement.models.CacheContract;
import com.azure.resourcemanager.apimanagement.models.CacheUpdateParameters;

public final class CacheContractImpl implements CacheContract, CacheContract.Definition, CacheContract.Update {
    private CacheContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String description() {
        return this.innerModel().description();
    }

    public String connectionString() {
        return this.innerModel().connectionString();
    }

    public String useFromLocation() {
        return this.innerModel().useFromLocation();
    }

    public String resourceId() {
        return this.innerModel().resourceId();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public CacheContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String cacheId;

    private String createIfMatch;

    private String updateIfMatch;

    private CacheUpdateParameters updateParameters;

    public CacheContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public CacheContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getCaches()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, cacheId, this.innerModel(), createIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public CacheContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getCaches()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, cacheId, this.innerModel(), createIfMatch,
                context)
            .getValue();
        return this;
    }

    CacheContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new CacheContractInner();
        this.serviceManager = serviceManager;
        this.cacheId = name;
        this.createIfMatch = null;
    }

    public CacheContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new CacheUpdateParameters();
        return this;
    }

    public CacheContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getCaches()
            .updateWithResponse(resourceGroupName, serviceName, cacheId, updateIfMatch, updateParameters, Context.NONE)
            .getValue();
        return this;
    }

    public CacheContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getCaches()
            .updateWithResponse(resourceGroupName, serviceName, cacheId, updateIfMatch, updateParameters, context)
            .getValue();
        return this;
    }

    CacheContractImpl(CacheContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.cacheId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "caches");
    }

    public CacheContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getCaches()
            .getWithResponse(resourceGroupName, serviceName, cacheId, Context.NONE)
            .getValue();
        return this;
    }

    public CacheContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getCaches()
            .getWithResponse(resourceGroupName, serviceName, cacheId, context)
            .getValue();
        return this;
    }

    public CacheContractImpl withDescription(String description) {
        if (isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        } else {
            this.updateParameters.withDescription(description);
            return this;
        }
    }

    public CacheContractImpl withConnectionString(String connectionString) {
        if (isInCreateMode()) {
            this.innerModel().withConnectionString(connectionString);
            return this;
        } else {
            this.updateParameters.withConnectionString(connectionString);
            return this;
        }
    }

    public CacheContractImpl withUseFromLocation(String useFromLocation) {
        if (isInCreateMode()) {
            this.innerModel().withUseFromLocation(useFromLocation);
            return this;
        } else {
            this.updateParameters.withUseFromLocation(useFromLocation);
            return this;
        }
    }

    public CacheContractImpl withResourceId(String resourceId) {
        if (isInCreateMode()) {
            this.innerModel().withResourceId(resourceId);
            return this;
        } else {
            this.updateParameters.withResourceId(resourceId);
            return this;
        }
    }

    public CacheContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
