// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.CachesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.CacheContractInner;
import com.azure.resourcemanager.apimanagement.models.CacheContract;
import com.azure.resourcemanager.apimanagement.models.Caches;
import com.azure.resourcemanager.apimanagement.models.CachesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.CachesGetResponse;

public final class CachesImpl implements Caches {
    private static final ClientLogger LOGGER = new ClientLogger(CachesImpl.class);

    private final CachesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public CachesImpl(CachesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<CacheContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<CacheContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CacheContractImpl(inner1, this.manager()));
    }

    public PagedIterable<CacheContract> listByService(String resourceGroupName, String serviceName, Integer top,
        Integer skip, Context context) {
        PagedIterable<CacheContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CacheContractImpl(inner1, this.manager()));
    }

    public CachesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String cacheId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, cacheId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String cacheId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, cacheId);
    }

    public Response<CacheContract> getWithResponse(String resourceGroupName, String serviceName, String cacheId,
        Context context) {
        CachesGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, cacheId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new CacheContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public CacheContract get(String resourceGroupName, String serviceName, String cacheId) {
        CacheContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, cacheId);
        if (inner != null) {
            return new CacheContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String cacheId,
        String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, cacheId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String cacheId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, cacheId, ifMatch);
    }

    public CacheContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String cacheId = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, cacheId, Context.NONE).getValue();
    }

    public Response<CacheContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String cacheId = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, cacheId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String cacheId = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, cacheId, localIfMatch, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String cacheId = ResourceManagerUtils.getValueFromIdByName(id, "caches");
        if (cacheId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'caches'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, cacheId, ifMatch, context);
    }

    private CachesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public CacheContractImpl define(String name) {
        return new CacheContractImpl(name, this.manager());
    }
}
