// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.CertificateContractInner;
import com.azure.resourcemanager.apimanagement.models.CertificateContract;
import com.azure.resourcemanager.apimanagement.models.CertificateCreateOrUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractCreateProperties;
import com.azure.resourcemanager.apimanagement.models.KeyVaultContractProperties;
import java.time.OffsetDateTime;

public final class CertificateContractImpl
    implements CertificateContract, CertificateContract.Definition, CertificateContract.Update {
    private CertificateContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String subject() {
        return this.innerModel().subject();
    }

    public String thumbprint() {
        return this.innerModel().thumbprint();
    }

    public OffsetDateTime expirationDate() {
        return this.innerModel().expirationDate();
    }

    public KeyVaultContractProperties keyVault() {
        return this.innerModel().keyVault();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public CertificateContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String certificateId;

    private String createIfMatch;

    private CertificateCreateOrUpdateParameters createParameters;

    private String updateIfMatch;

    private CertificateCreateOrUpdateParameters updateParameters;

    public CertificateContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public CertificateContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getCertificates()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, certificateId, createParameters, createIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public CertificateContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getCertificates()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, certificateId, createParameters, createIfMatch,
                context)
            .getValue();
        return this;
    }

    CertificateContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new CertificateContractInner();
        this.serviceManager = serviceManager;
        this.certificateId = name;
        this.createIfMatch = null;
        this.createParameters = new CertificateCreateOrUpdateParameters();
    }

    public CertificateContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new CertificateCreateOrUpdateParameters();
        return this;
    }

    public CertificateContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getCertificates()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, certificateId, updateParameters, updateIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public CertificateContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getCertificates()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, certificateId, updateParameters, updateIfMatch,
                context)
            .getValue();
        return this;
    }

    CertificateContractImpl(CertificateContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.certificateId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "certificates");
    }

    public CertificateContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getCertificates()
            .getWithResponse(resourceGroupName, serviceName, certificateId, Context.NONE)
            .getValue();
        return this;
    }

    public CertificateContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getCertificates()
            .getWithResponse(resourceGroupName, serviceName, certificateId, context)
            .getValue();
        return this;
    }

    public Response<CertificateContract> refreshSecretWithResponse(Context context) {
        return serviceManager.certificates()
            .refreshSecretWithResponse(resourceGroupName, serviceName, certificateId, context);
    }

    public CertificateContract refreshSecret() {
        return serviceManager.certificates().refreshSecret(resourceGroupName, serviceName, certificateId);
    }

    public CertificateContractImpl withData(String data) {
        if (isInCreateMode()) {
            this.createParameters.withData(data);
            return this;
        } else {
            this.updateParameters.withData(data);
            return this;
        }
    }

    public CertificateContractImpl withPassword(String password) {
        if (isInCreateMode()) {
            this.createParameters.withPassword(password);
            return this;
        } else {
            this.updateParameters.withPassword(password);
            return this;
        }
    }

    public CertificateContractImpl withKeyVault(KeyVaultContractCreateProperties keyVault) {
        if (isInCreateMode()) {
            this.createParameters.withKeyVault(keyVault);
            return this;
        } else {
            this.updateParameters.withKeyVault(keyVault);
            return this;
        }
    }

    public CertificateContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
