// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.resourcemanager.apimanagement.fluent.models.ConnectivityCheckResponseInner;
import com.azure.resourcemanager.apimanagement.models.ConnectionStatus;
import com.azure.resourcemanager.apimanagement.models.ConnectivityCheckResponse;
import com.azure.resourcemanager.apimanagement.models.ConnectivityHop;
import java.util.Collections;
import java.util.List;

public final class ConnectivityCheckResponseImpl implements ConnectivityCheckResponse {
    private ConnectivityCheckResponseInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    ConnectivityCheckResponseImpl(ConnectivityCheckResponseInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public List<ConnectivityHop> hops() {
        List<ConnectivityHop> inner = this.innerModel().hops();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public ConnectionStatus connectionStatus() {
        return this.innerModel().connectionStatus();
    }

    public Long avgLatencyInMs() {
        return this.innerModel().avgLatencyInMs();
    }

    public Long minLatencyInMs() {
        return this.innerModel().minLatencyInMs();
    }

    public Long maxLatencyInMs() {
        return this.innerModel().maxLatencyInMs();
    }

    public Long probesSent() {
        return this.innerModel().probesSent();
    }

    public Long probesFailed() {
        return this.innerModel().probesFailed();
    }

    public ConnectivityCheckResponseInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
