// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ContentItemContractInner;
import com.azure.resourcemanager.apimanagement.models.ContentItemContract;
import java.util.Collections;
import java.util.Map;

public final class ContentItemContractImpl
    implements ContentItemContract, ContentItemContract.Definition, ContentItemContract.Update {
    private ContentItemContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public Map<String, Object> properties() {
        Map<String, Object> inner = this.innerModel().properties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ContentItemContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String contentTypeId;

    private String contentItemId;

    private String createIfMatch;

    private String updateIfMatch;

    public ContentItemContractImpl withExistingContentType(String resourceGroupName, String serviceName,
        String contentTypeId) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        this.contentTypeId = contentTypeId;
        return this;
    }

    public ContentItemContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getContentItems()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, this.innerModel(),
                createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public ContentItemContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getContentItems()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, this.innerModel(),
                createIfMatch, context)
            .getValue();
        return this;
    }

    ContentItemContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new ContentItemContractInner();
        this.serviceManager = serviceManager;
        this.contentItemId = name;
        this.createIfMatch = null;
    }

    public ContentItemContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public ContentItemContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getContentItems()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, this.innerModel(),
                updateIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public ContentItemContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getContentItems()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, this.innerModel(),
                updateIfMatch, context)
            .getValue();
        return this;
    }

    ContentItemContractImpl(ContentItemContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.contentTypeId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "contentTypes");
        this.contentItemId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "contentItems");
    }

    public ContentItemContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getContentItems()
            .getWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, Context.NONE)
            .getValue();
        return this;
    }

    public ContentItemContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getContentItems()
            .getWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, context)
            .getValue();
        return this;
    }

    public ContentItemContractImpl withProperties(Map<String, Object> properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    public ContentItemContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
