// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.ContentItemsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ContentItemContractInner;
import com.azure.resourcemanager.apimanagement.models.ContentItemContract;
import com.azure.resourcemanager.apimanagement.models.ContentItems;
import com.azure.resourcemanager.apimanagement.models.ContentItemsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.ContentItemsGetResponse;

public final class ContentItemsImpl implements ContentItems {
    private static final ClientLogger LOGGER = new ClientLogger(ContentItemsImpl.class);

    private final ContentItemsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public ContentItemsImpl(ContentItemsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ContentItemContract> listByService(String resourceGroupName, String serviceName,
        String contentTypeId) {
        PagedIterable<ContentItemContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, contentTypeId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContentItemContractImpl(inner1, this.manager()));
    }

    public PagedIterable<ContentItemContract> listByService(String resourceGroupName, String serviceName,
        String contentTypeId, Context context) {
        PagedIterable<ContentItemContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, contentTypeId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ContentItemContractImpl(inner1, this.manager()));
    }

    public ContentItemsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String contentTypeId, String contentItemId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String contentTypeId, String contentItemId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, contentTypeId, contentItemId);
    }

    public Response<ContentItemContract> getWithResponse(String resourceGroupName, String serviceName,
        String contentTypeId, String contentItemId, Context context) {
        ContentItemsGetResponse inner = this.serviceClient()
            .getWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ContentItemContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ContentItemContract get(String resourceGroupName, String serviceName, String contentTypeId,
        String contentItemId) {
        ContentItemContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, contentTypeId, contentItemId);
        if (inner != null) {
            return new ContentItemContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String contentTypeId,
        String contentItemId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String contentTypeId, String contentItemId,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, contentTypeId, contentItemId, ifMatch);
    }

    public ContentItemContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String contentTypeId = ResourceManagerUtils.getValueFromIdByName(id, "contentTypes");
        if (contentTypeId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'contentTypes'.", id)));
        }
        String contentItemId = ResourceManagerUtils.getValueFromIdByName(id, "contentItems");
        if (contentItemId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'contentItems'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, Context.NONE)
            .getValue();
    }

    public Response<ContentItemContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String contentTypeId = ResourceManagerUtils.getValueFromIdByName(id, "contentTypes");
        if (contentTypeId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'contentTypes'.", id)));
        }
        String contentItemId = ResourceManagerUtils.getValueFromIdByName(id, "contentItems");
        if (contentItemId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'contentItems'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String contentTypeId = ResourceManagerUtils.getValueFromIdByName(id, "contentTypes");
        if (contentTypeId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'contentTypes'.", id)));
        }
        String contentItemId = ResourceManagerUtils.getValueFromIdByName(id, "contentItems");
        if (contentItemId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'contentItems'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, localIfMatch,
            Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String contentTypeId = ResourceManagerUtils.getValueFromIdByName(id, "contentTypes");
        if (contentTypeId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'contentTypes'.", id)));
        }
        String contentItemId = ResourceManagerUtils.getValueFromIdByName(id, "contentItems");
        if (contentItemId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'contentItems'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, contentTypeId, contentItemId, ifMatch, context);
    }

    private ContentItemsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public ContentItemContractImpl define(String name) {
        return new ContentItemContractImpl(name, this.manager());
    }
}
