// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.DocumentationContractInner;
import com.azure.resourcemanager.apimanagement.models.DocumentationContract;
import com.azure.resourcemanager.apimanagement.models.DocumentationUpdateContract;

public final class DocumentationContractImpl
    implements DocumentationContract, DocumentationContract.Definition, DocumentationContract.Update {
    private DocumentationContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String title() {
        return this.innerModel().title();
    }

    public String content() {
        return this.innerModel().content();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public DocumentationContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String documentationId;

    private String createIfMatch;

    private String updateIfMatch;

    private DocumentationUpdateContract updateParameters;

    public DocumentationContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public DocumentationContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getDocumentations()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, documentationId, this.innerModel(),
                createIfMatch, Context.NONE)
            .getValue();
        return this;
    }

    public DocumentationContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getDocumentations()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, documentationId, this.innerModel(),
                createIfMatch, context)
            .getValue();
        return this;
    }

    DocumentationContractImpl(String name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new DocumentationContractInner();
        this.serviceManager = serviceManager;
        this.documentationId = name;
        this.createIfMatch = null;
    }

    public DocumentationContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new DocumentationUpdateContract();
        return this;
    }

    public DocumentationContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getDocumentations()
            .updateWithResponse(resourceGroupName, serviceName, documentationId, updateIfMatch, updateParameters,
                Context.NONE)
            .getValue();
        return this;
    }

    public DocumentationContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getDocumentations()
            .updateWithResponse(resourceGroupName, serviceName, documentationId, updateIfMatch, updateParameters,
                context)
            .getValue();
        return this;
    }

    DocumentationContractImpl(DocumentationContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.documentationId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "documentations");
    }

    public DocumentationContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getDocumentations()
            .getWithResponse(resourceGroupName, serviceName, documentationId, Context.NONE)
            .getValue();
        return this;
    }

    public DocumentationContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getDocumentations()
            .getWithResponse(resourceGroupName, serviceName, documentationId, context)
            .getValue();
        return this;
    }

    public DocumentationContractImpl withTitle(String title) {
        if (isInCreateMode()) {
            this.innerModel().withTitle(title);
            return this;
        } else {
            this.updateParameters.withTitle(title);
            return this;
        }
    }

    public DocumentationContractImpl withContent(String content) {
        if (isInCreateMode()) {
            this.innerModel().withContent(content);
            return this;
        } else {
            this.updateParameters.withContent(content);
            return this;
        }
    }

    public DocumentationContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
