// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.DocumentationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.DocumentationContractInner;
import com.azure.resourcemanager.apimanagement.models.DocumentationContract;
import com.azure.resourcemanager.apimanagement.models.Documentations;
import com.azure.resourcemanager.apimanagement.models.DocumentationsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.DocumentationsGetResponse;

public final class DocumentationsImpl implements Documentations {
    private static final ClientLogger LOGGER = new ClientLogger(DocumentationsImpl.class);

    private final DocumentationsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public DocumentationsImpl(DocumentationsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<DocumentationContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<DocumentationContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DocumentationContractImpl(inner1, this.manager()));
    }

    public PagedIterable<DocumentationContract> listByService(String resourceGroupName, String serviceName,
        String filter, Integer top, Integer skip, Context context) {
        PagedIterable<DocumentationContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DocumentationContractImpl(inner1, this.manager()));
    }

    public DocumentationsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String documentationId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, documentationId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String documentationId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, documentationId);
    }

    public Response<DocumentationContract> getWithResponse(String resourceGroupName, String serviceName,
        String documentationId, Context context) {
        DocumentationsGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, documentationId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new DocumentationContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public DocumentationContract get(String resourceGroupName, String serviceName, String documentationId) {
        DocumentationContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, documentationId);
        if (inner != null) {
            return new DocumentationContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String documentationId,
        String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, documentationId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String documentationId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, documentationId, ifMatch);
    }

    public DocumentationContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String documentationId = ResourceManagerUtils.getValueFromIdByName(id, "documentations");
        if (documentationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'documentations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, documentationId, Context.NONE).getValue();
    }

    public Response<DocumentationContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String documentationId = ResourceManagerUtils.getValueFromIdByName(id, "documentations");
        if (documentationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'documentations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, documentationId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String documentationId = ResourceManagerUtils.getValueFromIdByName(id, "documentations");
        if (documentationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'documentations'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, documentationId, localIfMatch, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String documentationId = ResourceManagerUtils.getValueFromIdByName(id, "documentations");
        if (documentationId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'documentations'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, documentationId, ifMatch, context);
    }

    private DocumentationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public DocumentationContractImpl define(String name) {
        return new DocumentationContractImpl(name, this.manager());
    }
}
