// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.EmailTemplateContractInner;
import com.azure.resourcemanager.apimanagement.models.EmailTemplateContract;
import com.azure.resourcemanager.apimanagement.models.EmailTemplateParametersContractProperties;
import com.azure.resourcemanager.apimanagement.models.EmailTemplateUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.TemplateName;
import java.util.Collections;
import java.util.List;

public final class EmailTemplateContractImpl
    implements EmailTemplateContract, EmailTemplateContract.Definition, EmailTemplateContract.Update {
    private EmailTemplateContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String subject() {
        return this.innerModel().subject();
    }

    public String body() {
        return this.innerModel().body();
    }

    public String title() {
        return this.innerModel().title();
    }

    public String description() {
        return this.innerModel().description();
    }

    public Boolean isDefault() {
        return this.innerModel().isDefault();
    }

    public List<EmailTemplateParametersContractProperties> parameters() {
        List<EmailTemplateParametersContractProperties> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public EmailTemplateContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private TemplateName templateName;

    private String createIfMatch;

    private EmailTemplateUpdateParameters createParameters;

    private String updateIfMatch;

    private EmailTemplateUpdateParameters updateParameters;

    public EmailTemplateContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public EmailTemplateContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getEmailTemplates()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, templateName, createParameters, createIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public EmailTemplateContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getEmailTemplates()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, templateName, createParameters, createIfMatch,
                context)
            .getValue();
        return this;
    }

    EmailTemplateContractImpl(TemplateName name,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new EmailTemplateContractInner();
        this.serviceManager = serviceManager;
        this.templateName = name;
        this.createIfMatch = null;
        this.createParameters = new EmailTemplateUpdateParameters();
    }

    public EmailTemplateContractImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new EmailTemplateUpdateParameters();
        return this;
    }

    public EmailTemplateContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getEmailTemplates()
            .updateWithResponse(resourceGroupName, serviceName, templateName, updateIfMatch, updateParameters,
                Context.NONE)
            .getValue();
        return this;
    }

    public EmailTemplateContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getEmailTemplates()
            .updateWithResponse(resourceGroupName, serviceName, templateName, updateIfMatch, updateParameters, context)
            .getValue();
        return this;
    }

    EmailTemplateContractImpl(EmailTemplateContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.templateName
            = TemplateName.fromString(ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "templates"));
    }

    public EmailTemplateContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getEmailTemplates()
            .getWithResponse(resourceGroupName, serviceName, templateName, Context.NONE)
            .getValue();
        return this;
    }

    public EmailTemplateContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getEmailTemplates()
            .getWithResponse(resourceGroupName, serviceName, templateName, context)
            .getValue();
        return this;
    }

    public EmailTemplateContractImpl withSubject(String subject) {
        if (isInCreateMode()) {
            this.createParameters.withSubject(subject);
            return this;
        } else {
            this.updateParameters.withSubject(subject);
            return this;
        }
    }

    public EmailTemplateContractImpl withTitle(String title) {
        if (isInCreateMode()) {
            this.createParameters.withTitle(title);
            return this;
        } else {
            this.updateParameters.withTitle(title);
            return this;
        }
    }

    public EmailTemplateContractImpl withDescription(String description) {
        if (isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        } else {
            this.updateParameters.withDescription(description);
            return this;
        }
    }

    public EmailTemplateContractImpl withBody(String body) {
        if (isInCreateMode()) {
            this.createParameters.withBody(body);
            return this;
        } else {
            this.updateParameters.withBody(body);
            return this;
        }
    }

    public EmailTemplateContractImpl withParameters(List<EmailTemplateParametersContractProperties> parameters) {
        if (isInCreateMode()) {
            this.createParameters.withParameters(parameters);
            return this;
        } else {
            this.updateParameters.withParameters(parameters);
            return this;
        }
    }

    public EmailTemplateContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
