// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayContractInner;
import com.azure.resourcemanager.apimanagement.models.GatewayContract;
import com.azure.resourcemanager.apimanagement.models.GatewayDebugCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.GatewayKeyRegenerationRequestContract;
import com.azure.resourcemanager.apimanagement.models.GatewayKeysContract;
import com.azure.resourcemanager.apimanagement.models.GatewayListDebugCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.GatewayListTraceContract;
import com.azure.resourcemanager.apimanagement.models.GatewayTokenContract;
import com.azure.resourcemanager.apimanagement.models.GatewayTokenRequestContract;
import com.azure.resourcemanager.apimanagement.models.ResourceLocationDataContract;
import java.util.Map;

public final class GatewayContractImpl implements GatewayContract, GatewayContract.Definition, GatewayContract.Update {
    private GatewayContractInner innerObject;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public ResourceLocationDataContract locationData() {
        return this.innerModel().locationData();
    }

    public String description() {
        return this.innerModel().description();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public GatewayContractInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serviceName;

    private String gatewayId;

    private String createIfMatch;

    private String updateIfMatch;

    public GatewayContractImpl withExistingService(String resourceGroupName, String serviceName) {
        this.resourceGroupName = resourceGroupName;
        this.serviceName = serviceName;
        return this;
    }

    public GatewayContract create() {
        this.innerObject = serviceManager.serviceClient()
            .getGateways()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, gatewayId, this.innerModel(), createIfMatch,
                Context.NONE)
            .getValue();
        return this;
    }

    public GatewayContract create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getGateways()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, gatewayId, this.innerModel(), createIfMatch,
                context)
            .getValue();
        return this;
    }

    GatewayContractImpl(String name, com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = new GatewayContractInner();
        this.serviceManager = serviceManager;
        this.gatewayId = name;
        this.createIfMatch = null;
    }

    public GatewayContractImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    public GatewayContract apply() {
        this.innerObject = serviceManager.serviceClient()
            .getGateways()
            .updateWithResponse(resourceGroupName, serviceName, gatewayId, updateIfMatch, this.innerModel(),
                Context.NONE)
            .getValue();
        return this;
    }

    public GatewayContract apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getGateways()
            .updateWithResponse(resourceGroupName, serviceName, gatewayId, updateIfMatch, this.innerModel(), context)
            .getValue();
        return this;
    }

    GatewayContractImpl(GatewayContractInner innerObject,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "service");
        this.gatewayId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "gateways");
    }

    public GatewayContract refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getGateways()
            .getWithResponse(resourceGroupName, serviceName, gatewayId, Context.NONE)
            .getValue();
        return this;
    }

    public GatewayContract refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getGateways()
            .getWithResponse(resourceGroupName, serviceName, gatewayId, context)
            .getValue();
        return this;
    }

    public Response<GatewayKeysContract> listKeysWithResponse(Context context) {
        return serviceManager.gateways().listKeysWithResponse(resourceGroupName, serviceName, gatewayId, context);
    }

    public GatewayKeysContract listKeys() {
        return serviceManager.gateways().listKeys(resourceGroupName, serviceName, gatewayId);
    }

    public Response<Void> regenerateKeyWithResponse(GatewayKeyRegenerationRequestContract parameters, Context context) {
        return serviceManager.gateways()
            .regenerateKeyWithResponse(resourceGroupName, serviceName, gatewayId, parameters, context);
    }

    public void regenerateKey(GatewayKeyRegenerationRequestContract parameters) {
        serviceManager.gateways().regenerateKey(resourceGroupName, serviceName, gatewayId, parameters);
    }

    public Response<GatewayTokenContract> generateTokenWithResponse(GatewayTokenRequestContract parameters,
        Context context) {
        return serviceManager.gateways()
            .generateTokenWithResponse(resourceGroupName, serviceName, gatewayId, parameters, context);
    }

    public GatewayTokenContract generateToken(GatewayTokenRequestContract parameters) {
        return serviceManager.gateways().generateToken(resourceGroupName, serviceName, gatewayId, parameters);
    }

    public Response<Void> invalidateDebugCredentialsWithResponse(Context context) {
        return serviceManager.gateways()
            .invalidateDebugCredentialsWithResponse(resourceGroupName, serviceName, gatewayId, context);
    }

    public void invalidateDebugCredentials() {
        serviceManager.gateways().invalidateDebugCredentials(resourceGroupName, serviceName, gatewayId);
    }

    public Response<GatewayDebugCredentialsContract>
        listDebugCredentialsWithResponse(GatewayListDebugCredentialsContract parameters, Context context) {
        return serviceManager.gateways()
            .listDebugCredentialsWithResponse(resourceGroupName, serviceName, gatewayId, parameters, context);
    }

    public GatewayDebugCredentialsContract listDebugCredentials(GatewayListDebugCredentialsContract parameters) {
        return serviceManager.gateways().listDebugCredentials(resourceGroupName, serviceName, gatewayId, parameters);
    }

    public Response<Map<String, Object>> listTraceWithResponse(GatewayListTraceContract parameters, Context context) {
        return serviceManager.gateways()
            .listTraceWithResponse(resourceGroupName, serviceName, gatewayId, parameters, context);
    }

    public Map<String, Object> listTrace(GatewayListTraceContract parameters) {
        return serviceManager.gateways().listTrace(resourceGroupName, serviceName, gatewayId, parameters);
    }

    public GatewayContractImpl withLocationData(ResourceLocationDataContract locationData) {
        this.innerModel().withLocationData(locationData);
        return this;
    }

    public GatewayContractImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    public GatewayContractImpl withIfMatch(String ifMatch) {
        if (isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        } else {
            this.updateIfMatch = ifMatch;
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
