// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.GatewaysClient;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayDebugCredentialsContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayKeysContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.GatewayTokenContractInner;
import com.azure.resourcemanager.apimanagement.models.GatewayContract;
import com.azure.resourcemanager.apimanagement.models.GatewayDebugCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.GatewayKeyRegenerationRequestContract;
import com.azure.resourcemanager.apimanagement.models.GatewayKeysContract;
import com.azure.resourcemanager.apimanagement.models.GatewayListDebugCredentialsContract;
import com.azure.resourcemanager.apimanagement.models.GatewayListTraceContract;
import com.azure.resourcemanager.apimanagement.models.GatewayTokenContract;
import com.azure.resourcemanager.apimanagement.models.GatewayTokenRequestContract;
import com.azure.resourcemanager.apimanagement.models.Gateways;
import com.azure.resourcemanager.apimanagement.models.GatewaysGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.GatewaysGetResponse;
import com.azure.resourcemanager.apimanagement.models.GatewaysListKeysResponse;
import java.util.Collections;
import java.util.Map;

public final class GatewaysImpl implements Gateways {
    private static final ClientLogger LOGGER = new ClientLogger(GatewaysImpl.class);

    private final GatewaysClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public GatewaysImpl(GatewaysClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<GatewayContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<GatewayContractInner> inner = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GatewayContractImpl(inner1, this.manager()));
    }

    public PagedIterable<GatewayContract> listByService(String resourceGroupName, String serviceName, String filter,
        Integer top, Integer skip, Context context) {
        PagedIterable<GatewayContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GatewayContractImpl(inner1, this.manager()));
    }

    public GatewaysGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String gatewayId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, gatewayId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String gatewayId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, gatewayId);
    }

    public Response<GatewayContract> getWithResponse(String resourceGroupName, String serviceName, String gatewayId,
        Context context) {
        GatewaysGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, gatewayId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new GatewayContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public GatewayContract get(String resourceGroupName, String serviceName, String gatewayId) {
        GatewayContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, gatewayId);
        if (inner != null) {
            return new GatewayContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String gatewayId,
        String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, gatewayId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String gatewayId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, gatewayId, ifMatch);
    }

    public Response<GatewayKeysContract> listKeysWithResponse(String resourceGroupName, String serviceName,
        String gatewayId, Context context) {
        GatewaysListKeysResponse inner
            = this.serviceClient().listKeysWithResponse(resourceGroupName, serviceName, gatewayId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new GatewayKeysContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public GatewayKeysContract listKeys(String resourceGroupName, String serviceName, String gatewayId) {
        GatewayKeysContractInner inner = this.serviceClient().listKeys(resourceGroupName, serviceName, gatewayId);
        if (inner != null) {
            return new GatewayKeysContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> regenerateKeyWithResponse(String resourceGroupName, String serviceName, String gatewayId,
        GatewayKeyRegenerationRequestContract parameters, Context context) {
        return this.serviceClient()
            .regenerateKeyWithResponse(resourceGroupName, serviceName, gatewayId, parameters, context);
    }

    public void regenerateKey(String resourceGroupName, String serviceName, String gatewayId,
        GatewayKeyRegenerationRequestContract parameters) {
        this.serviceClient().regenerateKey(resourceGroupName, serviceName, gatewayId, parameters);
    }

    public Response<GatewayTokenContract> generateTokenWithResponse(String resourceGroupName, String serviceName,
        String gatewayId, GatewayTokenRequestContract parameters, Context context) {
        Response<GatewayTokenContractInner> inner = this.serviceClient()
            .generateTokenWithResponse(resourceGroupName, serviceName, gatewayId, parameters, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new GatewayTokenContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public GatewayTokenContract generateToken(String resourceGroupName, String serviceName, String gatewayId,
        GatewayTokenRequestContract parameters) {
        GatewayTokenContractInner inner
            = this.serviceClient().generateToken(resourceGroupName, serviceName, gatewayId, parameters);
        if (inner != null) {
            return new GatewayTokenContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> invalidateDebugCredentialsWithResponse(String resourceGroupName, String serviceName,
        String gatewayId, Context context) {
        return this.serviceClient()
            .invalidateDebugCredentialsWithResponse(resourceGroupName, serviceName, gatewayId, context);
    }

    public void invalidateDebugCredentials(String resourceGroupName, String serviceName, String gatewayId) {
        this.serviceClient().invalidateDebugCredentials(resourceGroupName, serviceName, gatewayId);
    }

    public Response<GatewayDebugCredentialsContract> listDebugCredentialsWithResponse(String resourceGroupName,
        String serviceName, String gatewayId, GatewayListDebugCredentialsContract parameters, Context context) {
        Response<GatewayDebugCredentialsContractInner> inner = this.serviceClient()
            .listDebugCredentialsWithResponse(resourceGroupName, serviceName, gatewayId, parameters, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new GatewayDebugCredentialsContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public GatewayDebugCredentialsContract listDebugCredentials(String resourceGroupName, String serviceName,
        String gatewayId, GatewayListDebugCredentialsContract parameters) {
        GatewayDebugCredentialsContractInner inner
            = this.serviceClient().listDebugCredentials(resourceGroupName, serviceName, gatewayId, parameters);
        if (inner != null) {
            return new GatewayDebugCredentialsContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Map<String, Object>> listTraceWithResponse(String resourceGroupName, String serviceName,
        String gatewayId, GatewayListTraceContract parameters, Context context) {
        return this.serviceClient()
            .listTraceWithResponse(resourceGroupName, serviceName, gatewayId, parameters, context);
    }

    public Map<String, Object> listTrace(String resourceGroupName, String serviceName, String gatewayId,
        GatewayListTraceContract parameters) {
        Map<String, Object> inner
            = this.serviceClient().listTrace(resourceGroupName, serviceName, gatewayId, parameters);
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public GatewayContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String gatewayId = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, gatewayId, Context.NONE).getValue();
    }

    public Response<GatewayContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String gatewayId = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, gatewayId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String gatewayId = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, gatewayId, localIfMatch, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String gatewayId = ResourceManagerUtils.getValueFromIdByName(id, "gateways");
        if (gatewayId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'gateways'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, gatewayId, ifMatch, context);
    }

    private GatewaysClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public GatewayContractImpl define(String name) {
        return new GatewayContractImpl(name, this.manager());
    }
}
